/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.hal;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.MapSerializer;
import com.fasterxml.jackson.databind.ser.std.NonTypedScalarSerializerBase;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.RelProvider;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.hal.CurieProvider;
import org.springframework.hateoas.hal.HalEmbeddedBuilder;
import org.springframework.hateoas.hal.LinkMixin;
import org.springframework.hateoas.hal.ResourceSupportMixin;
import org.springframework.hateoas.hal.ResourcesMixin;
import org.springframework.util.Assert;

public class Jackson2HalModule
extends SimpleModule {
    private static final long serialVersionUID = 7806951456457932384L;
    private static final Link CURIES_REQUIRED_DUE_TO_EMBEDS = new Link("__rel__", "\u00af\\_(\u30c4)_/\u00af");

    public Jackson2HalModule() {
        super("json-hal-module", new Version(1, 0, 0, null, "org.springframework.hateoas", "spring-hateoas"));
        this.setMixInAnnotation(Link.class, LinkMixin.class);
        this.setMixInAnnotation(ResourceSupport.class, ResourceSupportMixin.class);
        this.setMixInAnnotation(Resources.class, ResourcesMixin.class);
    }

    public static boolean isAlreadyRegisteredIn(ObjectMapper mapper) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        return LinkMixin.class.equals((Object)mapper.findMixInClassFor(Link.class));
    }

    static class HalLink {
        private final Link link;
        private final String title;

        public HalLink(Link link, String title) {
            this.link = link;
            this.title = title;
        }

        @JsonUnwrapped
        public Link getLink() {
            return this.link;
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public String getTitle() {
            return this.title;
        }
    }

    private static class EmbeddedMapper {
        private RelProvider relProvider;
        private CurieProvider curieProvider;
        private boolean preferCollectionRels;

        public EmbeddedMapper(RelProvider relProvider, CurieProvider curieProvider, boolean preferCollectionRels) {
            Assert.notNull((Object)relProvider, (String)"RelProvider must not be null!");
            this.relProvider = relProvider;
            this.curieProvider = curieProvider;
            this.preferCollectionRels = preferCollectionRels;
        }

        public Map<String, Object> map(Iterable<?> source) {
            Assert.notNull(source, (String)"Elements must not be null!");
            HalEmbeddedBuilder builder = new HalEmbeddedBuilder(this.relProvider, this.curieProvider, this.preferCollectionRels);
            for (Object resource : source) {
                builder.add(resource);
            }
            return builder.asMap();
        }

        public boolean hasCuriedEmbed(Iterable<?> source) {
            for (String rel : this.map(source).keySet()) {
                if (!rel.contains(":")) continue;
                return true;
            }
            return false;
        }
    }

    public static class TrueOnlyBooleanSerializer
    extends NonTypedScalarSerializerBase<Boolean> {
        private static final long serialVersionUID = 5817795880782727569L;

        public TrueOnlyBooleanSerializer() {
            super(Boolean.class);
        }

        public boolean isEmpty(Boolean value) {
            return this.isEmpty(null, value);
        }

        public boolean isEmpty(SerializerProvider provider, Boolean value) {
            return value == null || Boolean.FALSE.equals(value);
        }

        public void serialize(Boolean value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeBoolean(value.booleanValue());
        }

        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            return this.createSchemaNode("boolean", true);
        }

        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            if (visitor != null) {
                visitor.expectBooleanFormat(typeHint);
            }
        }
    }

    public static class HalHandlerInstantiator
    extends HandlerInstantiator {
        private final Map<Class<?>, Object> instanceMap = new HashMap();

        public HalHandlerInstantiator(RelProvider resolver, CurieProvider curieProvider, MessageSourceAccessor messageSource) {
            this(resolver, curieProvider, messageSource, true);
        }

        public HalHandlerInstantiator(RelProvider resolver, CurieProvider curieProvider, MessageSourceAccessor messageSource, boolean enforceEmbeddedCollections) {
            EmbeddedMapper mapper = new EmbeddedMapper(resolver, curieProvider, enforceEmbeddedCollections);
            Assert.notNull((Object)resolver, (String)"RelProvider must not be null!");
            this.instanceMap.put(HalResourcesSerializer.class, (Object)new HalResourcesSerializer(mapper));
            this.instanceMap.put(HalLinkListSerializer.class, (Object)new HalLinkListSerializer(curieProvider, mapper, messageSource));
        }

        private Object findInstance(Class<?> type) {
            Object result = this.instanceMap.get(type);
            return result != null ? result : BeanUtils.instantiateClass(type);
        }

        public JsonDeserializer<?> deserializerInstance(DeserializationConfig config, Annotated annotated, Class<?> deserClass) {
            return (JsonDeserializer)this.findInstance(deserClass);
        }

        public KeyDeserializer keyDeserializerInstance(DeserializationConfig config, Annotated annotated, Class<?> keyDeserClass) {
            return (KeyDeserializer)this.findInstance(keyDeserClass);
        }

        public JsonSerializer<?> serializerInstance(SerializationConfig config, Annotated annotated, Class<?> serClass) {
            return (JsonSerializer)this.findInstance(serClass);
        }

        public TypeResolverBuilder<?> typeResolverBuilderInstance(MapperConfig<?> config, Annotated annotated, Class<?> builderClass) {
            return (TypeResolverBuilder)this.findInstance(builderClass);
        }

        public TypeIdResolver typeIdResolverInstance(MapperConfig<?> config, Annotated annotated, Class<?> resolverClass) {
            return (TypeIdResolver)this.findInstance(resolverClass);
        }
    }

    public static class HalResourcesDeserializer
    extends ContainerDeserializerBase<List<Object>>
    implements ContextualDeserializer {
        private static final long serialVersionUID = 4755806754621032622L;
        private JavaType contentType;

        public HalResourcesDeserializer() {
            this((JavaType)TypeFactory.defaultInstance().constructCollectionLikeType(List.class, Object.class), null);
        }

        public HalResourcesDeserializer(JavaType vc) {
            this(null, vc);
        }

        private HalResourcesDeserializer(JavaType type, JavaType contentType) {
            super(type);
            this.contentType = contentType;
        }

        public JavaType getContentType() {
            return null;
        }

        public JsonDeserializer<Object> getContentDeserializer() {
            return null;
        }

        public List<Object> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ArrayList<Object> result = new ArrayList<Object>();
            JsonDeserializer deser = ctxt.findRootValueDeserializer(this.contentType);
            while (!JsonToken.END_OBJECT.equals((Object)jp.nextToken())) {
                Object object;
                if (!JsonToken.FIELD_NAME.equals((Object)jp.getCurrentToken())) {
                    throw new JsonParseException("Expected relation name", jp.getCurrentLocation());
                }
                if (JsonToken.START_ARRAY.equals((Object)jp.nextToken())) {
                    while (!JsonToken.END_ARRAY.equals((Object)jp.nextToken())) {
                        object = deser.deserialize(jp, ctxt);
                        result.add(object);
                    }
                    continue;
                }
                object = deser.deserialize(jp, ctxt);
                result.add(object);
            }
            return result;
        }

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
            JavaType vc = property.getType().getContentType();
            HalResourcesDeserializer des = new HalResourcesDeserializer(vc);
            return des;
        }
    }

    public static class HalLinkListDeserializer
    extends ContainerDeserializerBase<List<Link>> {
        private static final long serialVersionUID = 6420432361123210955L;

        public HalLinkListDeserializer() {
            super((JavaType)TypeFactory.defaultInstance().constructCollectionLikeType(List.class, Link.class));
        }

        public JavaType getContentType() {
            return null;
        }

        public JsonDeserializer<Object> getContentDeserializer() {
            return null;
        }

        public List<Link> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ArrayList<Link> result = new ArrayList<Link>();
            while (!JsonToken.END_OBJECT.equals((Object)jp.nextToken())) {
                Link link;
                if (!JsonToken.FIELD_NAME.equals((Object)jp.getCurrentToken())) {
                    throw new JsonParseException("Expected relation name", jp.getCurrentLocation());
                }
                String relation = jp.getText();
                if (JsonToken.START_ARRAY.equals((Object)jp.nextToken())) {
                    while (!JsonToken.END_ARRAY.equals((Object)jp.nextToken())) {
                        link = (Link)jp.readValueAs(Link.class);
                        result.add(new Link(link.getHref(), relation));
                    }
                    continue;
                }
                link = (Link)jp.readValueAs(Link.class);
                result.add(new Link(link.getHref(), relation));
            }
            return result;
        }
    }

    public static class OptionalListJackson2Serializer
    extends ContainerSerializer<Object>
    implements ContextualSerializer {
        private static final long serialVersionUID = 3700806118177419817L;
        private final BeanProperty property;
        private final Map<Class<?>, JsonSerializer<Object>> serializers;

        public OptionalListJackson2Serializer() {
            this(null);
        }

        public OptionalListJackson2Serializer(BeanProperty property) {
            super(TypeFactory.defaultInstance().constructType(List.class));
            this.property = property;
            this.serializers = new HashMap();
        }

        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            List list = (List)value;
            if (list.isEmpty()) {
                return;
            }
            if (list.size() == 1) {
                this.serializeContents(list.iterator(), jgen, provider);
                return;
            }
            jgen.writeStartArray();
            this.serializeContents(list.iterator(), jgen, provider);
            jgen.writeEndArray();
        }

        private void serializeContents(Iterator<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            while (value.hasNext()) {
                Object elem = value.next();
                if (elem == null) {
                    provider.defaultSerializeNull(jgen);
                    continue;
                }
                this.getOrLookupSerializerFor(elem.getClass(), provider).serialize(elem, jgen, provider);
            }
        }

        private JsonSerializer<Object> getOrLookupSerializerFor(Class<?> type, SerializerProvider provider) throws JsonMappingException {
            JsonSerializer serializer = this.serializers.get(type);
            if (serializer == null) {
                serializer = provider.findValueSerializer(type, this.property);
                this.serializers.put(type, (JsonSerializer<Object>)serializer);
            }
            return serializer;
        }

        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        public JavaType getContentType() {
            return null;
        }

        public boolean hasSingleElement(Object arg0) {
            return false;
        }

        public boolean isEmpty(Object value) {
            return this.isEmpty(null, value);
        }

        public boolean isEmpty(SerializerProvider provider, Object value) {
            return false;
        }

        public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
            return new OptionalListJackson2Serializer(property);
        }
    }

    public static class HalResourcesSerializer
    extends ContainerSerializer<Collection<?>>
    implements ContextualSerializer {
        private static final long serialVersionUID = 8030706944344625390L;
        private final BeanProperty property;
        private final EmbeddedMapper embeddedMapper;

        public HalResourcesSerializer(EmbeddedMapper embeddedMapper) {
            this(null, embeddedMapper);
        }

        public HalResourcesSerializer(BeanProperty property, EmbeddedMapper embeddedMapper) {
            super(TypeFactory.defaultInstance().constructType(Collection.class));
            this.property = property;
            this.embeddedMapper = embeddedMapper;
        }

        public void serialize(Collection<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            Map<String, Object> embeddeds = this.embeddedMapper.map(value);
            Object currentValue = jgen.getCurrentValue();
            if (currentValue instanceof ResourceSupport && this.embeddedMapper.hasCuriedEmbed(value)) {
                ((ResourceSupport)currentValue).add(CURIES_REQUIRED_DUE_TO_EMBEDS);
            }
            provider.findValueSerializer(Map.class, this.property).serialize(embeddeds, jgen, provider);
        }

        public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
            return new HalResourcesSerializer(property, this.embeddedMapper);
        }

        public JavaType getContentType() {
            return null;
        }

        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        public boolean isEmpty(Collection<?> value) {
            return this.isEmpty(null, value);
        }

        public boolean isEmpty(SerializerProvider provider, Collection<?> value) {
            return value.isEmpty();
        }

        public boolean hasSingleElement(Collection<?> value) {
            return value.size() == 1;
        }

        protected ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return null;
        }
    }

    public static class HalLinkListSerializer
    extends ContainerSerializer<List<Link>>
    implements ContextualSerializer {
        private static final long serialVersionUID = -1844788111509966406L;
        private static final String RELATION_MESSAGE_TEMPLATE = "_links.%s.title";
        private final BeanProperty property;
        private final CurieProvider curieProvider;
        private final EmbeddedMapper mapper;
        private final MessageSourceAccessor messageSource;

        public HalLinkListSerializer(CurieProvider curieProvider, EmbeddedMapper mapper, MessageSourceAccessor messageSource) {
            this(null, curieProvider, mapper, messageSource);
        }

        public HalLinkListSerializer(BeanProperty property, CurieProvider curieProvider, EmbeddedMapper mapper, MessageSourceAccessor messageSource) {
            super(TypeFactory.defaultInstance().constructType(List.class));
            this.property = property;
            this.curieProvider = curieProvider;
            this.mapper = mapper;
            this.messageSource = messageSource;
        }

        public void serialize(List<Link> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            LinkedHashMap sortedLinks = new LinkedHashMap();
            ArrayList<Link> links = new ArrayList<Link>();
            boolean prefixingRequired = this.curieProvider != null;
            boolean curiedLinkPresent = false;
            boolean skipCuries = !jgen.getOutputContext().getParent().inRoot();
            Object currentValue = jgen.getCurrentValue();
            if (currentValue instanceof Resources && this.mapper.hasCuriedEmbed((Resources)currentValue)) {
                curiedLinkPresent = true;
            }
            for (Link link : value) {
                String rel;
                if (link.equals(CURIES_REQUIRED_DUE_TO_EMBEDS)) continue;
                String string = rel = prefixingRequired ? this.curieProvider.getNamespacedRelFrom(link) : link.getRel();
                if (!link.getRel().equals(rel)) {
                    curiedLinkPresent = true;
                }
                if (sortedLinks.get(rel) == null) {
                    sortedLinks.put(rel, new ArrayList());
                }
                links.add(link);
                ((List)sortedLinks.get(rel)).add(this.toHalLink(link));
            }
            if (!skipCuries && prefixingRequired && curiedLinkPresent) {
                ArrayList<Collection<? extends Object>> curies = new ArrayList<Collection<? extends Object>>();
                curies.add(this.curieProvider.getCurieInformation(new Links(links)));
                sortedLinks.put("curies", curies);
            }
            TypeFactory typeFactory = provider.getConfig().getTypeFactory();
            JavaType keyType = typeFactory.uncheckedSimpleType(String.class);
            CollectionType valueType = typeFactory.constructCollectionType(ArrayList.class, Object.class);
            MapType mapType = typeFactory.constructMapType(HashMap.class, keyType, (JavaType)valueType);
            MapSerializer serializer = MapSerializer.construct((String[])new String[0], (JavaType)mapType, (boolean)true, null, (JsonSerializer)provider.findKeySerializer(keyType, null), (JsonSerializer)new OptionalListJackson2Serializer(this.property), null);
            serializer.serialize(sortedLinks, jgen, provider);
        }

        private HalLink toHalLink(Link link) {
            String rel = link.getRel();
            String title = this.getTitle(rel);
            if (title == null) {
                title = this.getTitle(rel.contains(":") ? rel.substring(rel.indexOf(":") + 1) : rel);
            }
            return new HalLink(link, title);
        }

        private String getTitle(String localRel) {
            Assert.hasText((String)localRel, (String)"Local relation must not be null or empty!");
            try {
                return this.messageSource == null ? null : this.messageSource.getMessage(String.format(RELATION_MESSAGE_TEMPLATE, localRel));
            }
            catch (NoSuchMessageException o_O) {
                return null;
            }
        }

        public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
            return new HalLinkListSerializer(property, this.curieProvider, this.mapper, this.messageSource);
        }

        public JavaType getContentType() {
            return null;
        }

        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        public boolean isEmpty(List<Link> value) {
            return this.isEmpty(null, value);
        }

        public boolean isEmpty(SerializerProvider provider, List<Link> value) {
            return value.isEmpty();
        }

        public boolean hasSingleElement(List<Link> value) {
            return value.size() == 1;
        }

        protected ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return null;
        }
    }
}

