/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import java.lang.annotation.Annotation;
import javax.ws.rs.Path;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.hateoas.EntityLinks;
import org.springframework.hateoas.LinkBuilderFactory;
import org.springframework.hateoas.core.ControllerEntityLinksFactoryBean;
import org.springframework.hateoas.core.DelegatingEntityLinks;
import org.springframework.hateoas.jaxrs.JaxRsLinkBuilderFactory;
import org.springframework.hateoas.mvc.ControllerLinkBuilderFactory;
import org.springframework.plugin.core.support.PluginRegistryFactoryBean;
import org.springframework.stereotype.Controller;
import org.springframework.util.ClassUtils;

public class LinkBuilderBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final boolean IS_JAX_RS_PRESENT = ClassUtils.isPresent((String)"javax.ws.rs.Path", (ClassLoader)ClassUtils.getDefaultClassLoader());

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder registryFactoryBeanBuilder = BeanDefinitionBuilder.rootBeanDefinition(PluginRegistryFactoryBean.class);
        registryFactoryBeanBuilder.addPropertyValue("type", EntityLinks.class);
        registryFactoryBeanBuilder.addPropertyValue("exclusions", DelegatingEntityLinks.class);
        AbstractBeanDefinition registryBeanDefinition = registryFactoryBeanBuilder.getBeanDefinition();
        registry.registerBeanDefinition("entityLinksPluginRegistry", (BeanDefinition)registryBeanDefinition);
        BeanDefinitionBuilder delegateBuilder = BeanDefinitionBuilder.rootBeanDefinition(DelegatingEntityLinks.class);
        delegateBuilder.addConstructorArgValue((Object)registryBeanDefinition);
        BeanDefinitionBuilder builder = LinkBuilderBeanDefinitionRegistrar.getEntityControllerLinksFor(Controller.class, ControllerLinkBuilderFactory.class);
        registry.registerBeanDefinition("controllerEntityLinks", (BeanDefinition)builder.getBeanDefinition());
        delegateBuilder.addDependsOn("controllerEntityLinks");
        if (IS_JAX_RS_PRESENT) {
            JaxRsEntityControllerBuilderDefinitionBuilder definitionBuilder = new JaxRsEntityControllerBuilderDefinitionBuilder();
            registry.registerBeanDefinition("jaxRsEntityLinks", definitionBuilder.getBeanDefinition());
            delegateBuilder.addDependsOn("jaxRsEntityLinks");
        }
        AbstractBeanDefinition beanDefinition = delegateBuilder.getBeanDefinition();
        beanDefinition.setPrimary(true);
        registry.registerBeanDefinition("delegatingEntityLinks", (BeanDefinition)beanDefinition);
    }

    private static BeanDefinitionBuilder getEntityControllerLinksFor(Class<? extends Annotation> type, Class<? extends LinkBuilderFactory<?>> linkBuilderFactoryType) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ControllerEntityLinksFactoryBean.class);
        builder.addPropertyValue("annotation", type);
        builder.addPropertyValue("linkBuilderFactory", (Object)new RootBeanDefinition(linkBuilderFactoryType));
        return builder;
    }

    static class JaxRsEntityControllerBuilderDefinitionBuilder {
        JaxRsEntityControllerBuilderDefinitionBuilder() {
        }

        public BeanDefinition getBeanDefinition() {
            BeanDefinitionBuilder builder = LinkBuilderBeanDefinitionRegistrar.getEntityControllerLinksFor(Path.class, JaxRsLinkBuilderFactory.class);
            return builder.getBeanDefinition();
        }
    }
}

