/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mvc;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.MethodParameter;
import org.springframework.hateoas.core.AnnotationAttribute;
import org.springframework.hateoas.core.MethodParameters;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AnnotatedParametersParameterAccessor {
    private final AnnotationAttribute attribute;

    public AnnotatedParametersParameterAccessor(AnnotationAttribute attribute) {
        Assert.notNull((Object)attribute);
        this.attribute = attribute;
    }

    public Map<String, Object> getBoundParameters(MethodInvocation invocation) {
        MethodParameters parameters = new MethodParameters(invocation.getMethod());
        Object[] arguments = invocation.getArguments();
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (MethodParameter parameter : parameters.getParametersWith(this.attribute.getAnnotationType())) {
            Annotation annotation = parameter.getParameterAnnotation(this.attribute.getAnnotationType());
            String annotationAttributeValue = this.attribute.getValueFrom(annotation);
            String key = StringUtils.hasText((String)annotationAttributeValue) ? annotationAttributeValue : parameter.getParameterName();
            result.put(key, arguments[parameter.getParameterIndex()]);
        }
        return result;
    }
}

