/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.dsl;

import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.integration.amqp.channel.AbstractAmqpChannel;
import org.springframework.integration.amqp.config.AmqpChannelFactoryBean;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.dsl.channel.MessageChannelSpec;
import org.springframework.util.Assert;

public class AmqpPollableMessageChannelSpec<S extends AmqpPollableMessageChannelSpec<S>>
extends MessageChannelSpec<S, AbstractAmqpChannel> {
    protected final AmqpChannelFactoryBean amqpChannelFactoryBean;

    AmqpPollableMessageChannelSpec(ConnectionFactory connectionFactory) {
        this(new AmqpChannelFactoryBean(false), connectionFactory);
    }

    AmqpPollableMessageChannelSpec(AmqpChannelFactoryBean amqpChannelFactoryBean, ConnectionFactory connectionFactory) {
        this.amqpChannelFactoryBean = amqpChannelFactoryBean;
        this.amqpChannelFactoryBean.setConnectionFactory(connectionFactory);
        this.amqpChannelFactoryBean.setSingleton(false);
        this.amqpChannelFactoryBean.setPubSub(false);
        this.amqpChannelFactoryBean.setBeanFactory((BeanFactory)new DefaultListableBeanFactory());
    }

    protected S id(String id) {
        this.amqpChannelFactoryBean.setBeanName(id);
        return (S)((Object)((AmqpPollableMessageChannelSpec)super.id(id)));
    }

    public S queueName(String queueName) {
        if (this.getId() == null) {
            this.id(queueName + ".channel");
        }
        this.amqpChannelFactoryBean.setQueueName(queueName);
        return (S)((Object)((AmqpPollableMessageChannelSpec)this._this()));
    }

    public S encoding(String encoding) {
        this.amqpChannelFactoryBean.setEncoding(encoding);
        return (S)((Object)((AmqpPollableMessageChannelSpec)this._this()));
    }

    public S amqpMessageConverter(MessageConverter messageConverter) {
        this.amqpChannelFactoryBean.setMessageConverter(messageConverter);
        return (S)((Object)((AmqpPollableMessageChannelSpec)this._this()));
    }

    public S channelTransacted(boolean channelTransacted) {
        this.amqpChannelFactoryBean.setChannelTransacted(channelTransacted);
        return (S)((Object)((AmqpPollableMessageChannelSpec)this._this()));
    }

    public S templateChannelTransacted(boolean channelTransacted) {
        this.amqpChannelFactoryBean.setTemplateChannelTransacted(channelTransacted);
        return (S)((Object)((AmqpPollableMessageChannelSpec)this._this()));
    }

    public S messagePropertiesConverter(MessagePropertiesConverter messagePropertiesConverter) {
        this.amqpChannelFactoryBean.setMessagePropertiesConverter(messagePropertiesConverter);
        return (S)((Object)((AmqpPollableMessageChannelSpec)this._this()));
    }

    public S defaultDeliveryMode(MessageDeliveryMode mode) {
        this.amqpChannelFactoryBean.setDefaultDeliveryMode(mode);
        return (S)((Object)((AmqpPollableMessageChannelSpec)this._this()));
    }

    public S extractPayload(boolean extract) {
        this.amqpChannelFactoryBean.setExtractPayload(extract);
        return (S)((Object)((AmqpPollableMessageChannelSpec)this._this()));
    }

    public S outboundHeaderMapper(AmqpHeaderMapper mapper) {
        this.amqpChannelFactoryBean.setOutboundHeaderMapper(mapper);
        return (S)((Object)((AmqpPollableMessageChannelSpec)this._this()));
    }

    public S inboundHeaderMapper(AmqpHeaderMapper mapper) {
        this.amqpChannelFactoryBean.setInboundHeaderMapper(mapper);
        return (S)((Object)((AmqpPollableMessageChannelSpec)this._this()));
    }

    public S headersMappedLast(boolean headersLast) {
        ((AbstractAmqpChannel)((Object)this.target)).setHeadersMappedLast(headersLast);
        return (S)((Object)((AmqpPollableMessageChannelSpec)this._this()));
    }

    protected AbstractAmqpChannel doGet() {
        Assert.notNull((Object)this.getId(), (String)"The 'id' or 'queueName' must be specified");
        try {
            this.channel = (AbstractMessageChannel)this.amqpChannelFactoryBean.getObject();
        }
        catch (Exception e) {
            throw new BeanCreationException("Cannot create the AMQP MessageChannel", (Throwable)e);
        }
        return (AbstractAmqpChannel)super.doGet();
    }
}

