/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.amqp.outbound.AmqpOutboundEndpoint;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class AmqpOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(AmqpOutboundEndpoint.class);
        String amqpTemplateRef = element.getAttribute("amqp-template");
        if (!StringUtils.hasText((String)amqpTemplateRef)) {
            amqpTemplateRef = "amqpTemplate";
            if (StringUtils.hasText((String)element.getAttribute("return-channel")) || StringUtils.hasText((String)element.getAttribute("confirm-correlation-expression"))) {
                parserContext.getReaderContext().error("A dedicated 'amqp-template' is required when using publisher confirms and returns", (Object)element);
            }
        }
        builder.addConstructorArgReference(amqpTemplateRef);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"exchange-name", (boolean)true);
        BeanDefinition exchangeNameExpression = IntegrationNamespaceUtils.createExpressionDefIfAttributeDefined((String)"exchange-name-expression", (Element)element);
        if (exchangeNameExpression != null) {
            builder.addPropertyValue("exchangeNameExpression", (Object)exchangeNameExpression);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"routing-key", (boolean)true);
        BeanDefinition routingKeyExpression = IntegrationNamespaceUtils.createExpressionDefIfAttributeDefined((String)"routing-key-expression", (Element)element);
        if (routingKeyExpression != null) {
            builder.addPropertyValue("routingKeyExpression", (Object)routingKeyExpression);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"default-delivery-mode");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"lazy-connect");
        BeanDefinitionBuilder mapperBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultAmqpHeaderMapper.class);
        mapperBuilder.setFactoryMethod("outboundMapper");
        IntegrationNamespaceUtils.configureHeaderMapper((Element)element, (BeanDefinitionBuilder)builder, (ParserContext)parserContext, (BeanDefinitionBuilder)mapperBuilder, null);
        BeanDefinition confirmCorrelationExpression = IntegrationNamespaceUtils.createExpressionDefIfAttributeDefined((String)"confirm-correlation-expression", (Element)element);
        if (confirmCorrelationExpression != null) {
            builder.addPropertyValue("confirmCorrelationExpression", (Object)confirmCorrelationExpression);
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"confirm-ack-channel");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"confirm-nack-channel");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"confirm-timeout");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"wait-for-confirm");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"return-channel");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"error-message-strategy");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"delay-expression", (String)"delayExpressionString");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"headers-last", (String)"headersMappedLast");
        return builder.getBeanDefinition();
    }
}

