/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.config;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import org.aopalliance.aop.Advice;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.RabbitAccessor;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.DirectMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.Lifecycle;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.JavaUtils;
import org.springframework.integration.amqp.channel.AbstractAmqpChannel;
import org.springframework.integration.amqp.channel.PointToPointSubscribableAmqpChannel;
import org.springframework.integration.amqp.channel.PollableAmqpChannel;
import org.springframework.integration.amqp.channel.PublishSubscribeAmqpChannel;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.lang.Nullable;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;

public class AmqpChannelFactoryBean
extends AbstractFactoryBean<AbstractAmqpChannel>
implements SmartLifecycle,
BeanNameAware {
    private final AmqpTemplate amqpTemplate = new RabbitTemplate();
    private final boolean messageDriven;
    private AbstractAmqpChannel channel;
    private List<ChannelInterceptor> interceptors;
    private AmqpAdmin amqpAdmin;
    private FanoutExchange exchange;
    private String queueName;
    private boolean autoStartup = true;
    private Advice[] adviceChain;
    private Integer concurrentConsumers;
    private Integer consumersPerQueue;
    private ConnectionFactory connectionFactory;
    private MessagePropertiesConverter messagePropertiesConverter;
    private ErrorHandler errorHandler;
    private Boolean exposeListenerChannel;
    private Integer phase;
    private Integer prefetchCount;
    private boolean isPubSub;
    private Long receiveTimeout;
    private Long recoveryInterval;
    private Long shutdownTimeout;
    private String beanName;
    private AcknowledgeMode acknowledgeMode;
    private boolean channelTransacted;
    private Executor taskExecutor;
    private PlatformTransactionManager transactionManager;
    private TransactionAttribute transactionAttribute;
    private Integer batchSize;
    private Integer maxSubscribers;
    private Boolean missingQueuesFatal;
    private MessageDeliveryMode defaultDeliveryMode;
    private Boolean extractPayload;
    private AmqpHeaderMapper outboundHeaderMapper = DefaultAmqpHeaderMapper.outboundMapper();
    private AmqpHeaderMapper inboundHeaderMapper = DefaultAmqpHeaderMapper.inboundMapper();
    private boolean headersLast;

    public AmqpChannelFactoryBean() {
        this(true);
    }

    public AmqpChannelFactoryBean(boolean messageDriven) {
        this.messageDriven = messageDriven;
    }

    public void setBeanName(@Nullable String name) {
        this.beanName = name;
    }

    public void setInterceptors(List<ChannelInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public void setAmqpAdmin(AmqpAdmin amqpAdmin) {
        this.amqpAdmin = amqpAdmin;
    }

    public void setExchange(FanoutExchange exchange) {
        this.exchange = exchange;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public void setEncoding(String encoding) {
        AmqpTemplate amqpTemplate = this.amqpTemplate;
        if (amqpTemplate instanceof RabbitTemplate) {
            RabbitTemplate rabbitTemplate = (RabbitTemplate)amqpTemplate;
            rabbitTemplate.setEncoding(encoding);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"AmqpTemplate is not a RabbitTemplate, so configured 'encoding' value will be ignored.");
        }
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        AmqpTemplate amqpTemplate = this.amqpTemplate;
        if (amqpTemplate instanceof RabbitTemplate) {
            RabbitTemplate rabbitTemplate = (RabbitTemplate)amqpTemplate;
            rabbitTemplate.setMessageConverter(messageConverter);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"AmqpTemplate is not a RabbitTemplate, so configured MessageConverter will be ignored.");
        }
    }

    public void setTemplateChannelTransacted(boolean channelTransacted) {
        AmqpTemplate amqpTemplate = this.amqpTemplate;
        if (amqpTemplate instanceof RabbitTemplate) {
            RabbitTemplate rabbitTemplate = (RabbitTemplate)amqpTemplate;
            rabbitTemplate.setChannelTransacted(channelTransacted);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"AmqpTemplate is not a RabbitTemplate, so configured 'channelTransacted' will be ignored.");
        }
    }

    public void setChannelTransacted(boolean channelTransacted) {
        this.channelTransacted = channelTransacted;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        AmqpTemplate amqpTemplate = this.amqpTemplate;
        if (amqpTemplate instanceof RabbitTemplate) {
            RabbitTemplate rabbitTemplate = (RabbitTemplate)amqpTemplate;
            rabbitTemplate.setConnectionFactory(this.connectionFactory);
        }
    }

    public void setMessagePropertiesConverter(MessagePropertiesConverter messagePropertiesConverter) {
        this.messagePropertiesConverter = messagePropertiesConverter;
        AmqpTemplate amqpTemplate = this.amqpTemplate;
        if (amqpTemplate instanceof RabbitTemplate) {
            RabbitTemplate rabbitTemplate = (RabbitTemplate)amqpTemplate;
            rabbitTemplate.setMessagePropertiesConverter(messagePropertiesConverter);
        }
    }

    public void setAcknowledgeMode(AcknowledgeMode acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public void setAdviceChain(Advice[] adviceChain) {
        this.adviceChain = Arrays.copyOf(adviceChain, adviceChain.length);
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public void setConsumersPerQueue(Integer consumersPerQueue) {
        this.consumersPerQueue = consumersPerQueue;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setExposeListenerChannel(boolean exposeListenerChannel) {
        this.exposeListenerChannel = exposeListenerChannel;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setPrefetchCount(int prefetchCount) {
        this.prefetchCount = prefetchCount;
    }

    public void setPubSub(boolean pubSub) {
        this.isPubSub = pubSub;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }

    public void setShutdownTimeout(long shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setTransactionAttribute(TransactionAttribute transactionAttribute) {
        this.transactionAttribute = transactionAttribute;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public void setMaxSubscribers(int maxSubscribers) {
        this.maxSubscribers = maxSubscribers;
    }

    public void setMissingQueuesFatal(Boolean missingQueuesFatal) {
        this.missingQueuesFatal = missingQueuesFatal;
    }

    public void setDefaultDeliveryMode(MessageDeliveryMode defaultDeliveryMode) {
        this.defaultDeliveryMode = defaultDeliveryMode;
    }

    public void setExtractPayload(Boolean extractPayload) {
        this.extractPayload = extractPayload;
    }

    public void setOutboundHeaderMapper(AmqpHeaderMapper outboundMapper) {
        this.outboundHeaderMapper = outboundMapper;
    }

    public void setInboundHeaderMapper(AmqpHeaderMapper inboundMapper) {
        this.inboundHeaderMapper = inboundMapper;
    }

    public void setHeadersLast(boolean headersLast) {
        this.headersLast = headersLast;
    }

    public Class<?> getObjectType() {
        return this.channel != null ? ((Object)((Object)this.channel)).getClass() : AbstractAmqpChannel.class;
    }

    protected AbstractAmqpChannel createInstance() {
        if (this.messageDriven) {
            AbstractMessageListenerContainer container = this.createContainer();
            AmqpTemplate amqpTemplate = this.amqpTemplate;
            if (amqpTemplate instanceof RabbitAccessor) {
                RabbitAccessor rabbitAccessor = (RabbitAccessor)amqpTemplate;
                rabbitAccessor.afterPropertiesSet();
            }
            if (this.isPubSub) {
                PublishSubscribeAmqpChannel pubsub = new PublishSubscribeAmqpChannel(this.beanName, container, this.amqpTemplate, this.outboundHeaderMapper, this.inboundHeaderMapper);
                JavaUtils.INSTANCE.acceptIfNotNull((Object)this.exchange, pubsub::setExchange).acceptIfNotNull((Object)this.maxSubscribers, x$0 -> pubsub.setMaxSubscribers((int)x$0));
                this.channel = pubsub;
            } else {
                PointToPointSubscribableAmqpChannel p2p = new PointToPointSubscribableAmqpChannel(this.beanName, container, this.amqpTemplate, this.outboundHeaderMapper, this.inboundHeaderMapper);
                JavaUtils.INSTANCE.acceptIfHasText(this.queueName, p2p::setQueueName).acceptIfNotNull((Object)this.maxSubscribers, x$0 -> p2p.setMaxSubscribers((int)x$0));
                this.channel = p2p;
            }
        } else {
            Assert.isTrue((!this.isPubSub ? 1 : 0) != 0, (String)"An AMQP 'publish-subscribe-channel' must be message-driven.");
            PollableAmqpChannel pollable = new PollableAmqpChannel(this.beanName, this.amqpTemplate, this.outboundHeaderMapper, this.inboundHeaderMapper);
            JavaUtils.INSTANCE.acceptIfNotNull((Object)this.amqpAdmin, pollable::setAmqpAdmin).acceptIfHasText(this.queueName, pollable::setQueueName);
            this.channel = pollable;
        }
        JavaUtils.INSTANCE.acceptIfNotEmpty(this.interceptors, arg_0 -> ((AbstractAmqpChannel)this.channel).setInterceptors(arg_0));
        this.channel.setBeanName(this.beanName);
        JavaUtils.INSTANCE.acceptIfNotNull((Object)this.getBeanFactory(), arg_0 -> ((AbstractAmqpChannel)this.channel).setBeanFactory(arg_0)).acceptIfNotNull((Object)this.defaultDeliveryMode, this.channel::setDefaultDeliveryMode).acceptIfNotNull((Object)this.extractPayload, this.channel::setExtractPayload);
        this.channel.setHeadersMappedLast(this.headersLast);
        this.channel.afterPropertiesSet();
        return this.channel;
    }

    private AbstractMessageListenerContainer createContainer() {
        DirectMessageListenerContainer container;
        if (this.consumersPerQueue == null) {
            SimpleMessageListenerContainer smlc = new SimpleMessageListenerContainer();
            JavaUtils.INSTANCE.acceptIfNotNull((Object)this.concurrentConsumers, arg_0 -> ((SimpleMessageListenerContainer)smlc).setConcurrentConsumers(arg_0)).acceptIfNotNull((Object)this.receiveTimeout, arg_0 -> ((SimpleMessageListenerContainer)smlc).setReceiveTimeout(arg_0)).acceptIfNotNull((Object)this.batchSize, arg_0 -> ((SimpleMessageListenerContainer)smlc).setBatchSize(arg_0));
            container = smlc;
        } else {
            DirectMessageListenerContainer dmlc = new DirectMessageListenerContainer();
            dmlc.setConsumersPerQueue(this.consumersPerQueue.intValue());
            container = dmlc;
        }
        JavaUtils.INSTANCE.acceptIfNotNull((Object)this.acknowledgeMode, arg_0 -> ((AbstractMessageListenerContainer)container).setAcknowledgeMode(arg_0)).acceptIfNotEmpty((Object[])this.adviceChain, arg_0 -> ((AbstractMessageListenerContainer)container).setAdviceChain(arg_0));
        container.setAutoStartup(this.autoStartup);
        container.setChannelTransacted(this.channelTransacted);
        container.setConnectionFactory(this.connectionFactory);
        JavaUtils.INSTANCE.acceptIfNotNull((Object)this.errorHandler, arg_0 -> ((AbstractMessageListenerContainer)container).setErrorHandler(arg_0)).acceptIfNotNull((Object)this.exposeListenerChannel, arg_0 -> ((AbstractMessageListenerContainer)container).setExposeListenerChannel(arg_0)).acceptIfNotNull((Object)this.messagePropertiesConverter, arg_0 -> ((AbstractMessageListenerContainer)container).setMessagePropertiesConverter(arg_0)).acceptIfNotNull((Object)this.phase, arg_0 -> ((AbstractMessageListenerContainer)container).setPhase(arg_0)).acceptIfNotNull((Object)this.prefetchCount, arg_0 -> ((AbstractMessageListenerContainer)container).setPrefetchCount(arg_0)).acceptIfNotNull((Object)this.recoveryInterval, arg_0 -> ((AbstractMessageListenerContainer)container).setRecoveryInterval(arg_0)).acceptIfNotNull((Object)this.shutdownTimeout, arg_0 -> ((AbstractMessageListenerContainer)container).setShutdownTimeout(arg_0)).acceptIfNotNull((Object)this.taskExecutor, arg_0 -> ((AbstractMessageListenerContainer)container).setTaskExecutor(arg_0)).acceptIfNotNull((Object)this.transactionAttribute, arg_0 -> ((AbstractMessageListenerContainer)container).setTransactionAttribute(arg_0)).acceptIfNotNull((Object)this.transactionManager, arg_0 -> ((AbstractMessageListenerContainer)container).setTransactionManager(arg_0)).acceptIfNotNull((Object)this.missingQueuesFatal, arg_0 -> ((AbstractMessageListenerContainer)container).setMissingQueuesFatal(arg_0));
        return container;
    }

    public boolean isAutoStartup() {
        SmartLifecycle smartLifecycle;
        AbstractAmqpChannel abstractAmqpChannel = this.channel;
        return abstractAmqpChannel instanceof SmartLifecycle && (smartLifecycle = (SmartLifecycle)abstractAmqpChannel).isAutoStartup();
    }

    public int getPhase() {
        int n;
        AbstractAmqpChannel abstractAmqpChannel = this.channel;
        if (abstractAmqpChannel instanceof SmartLifecycle) {
            SmartLifecycle smartLifecycle = (SmartLifecycle)abstractAmqpChannel;
            n = smartLifecycle.getPhase();
        } else {
            n = 0;
        }
        return n;
    }

    public boolean isRunning() {
        Lifecycle lifecycle;
        AbstractAmqpChannel abstractAmqpChannel = this.channel;
        return abstractAmqpChannel instanceof Lifecycle && (lifecycle = (Lifecycle)abstractAmqpChannel).isRunning();
    }

    public void start() {
        AbstractAmqpChannel abstractAmqpChannel = this.channel;
        if (abstractAmqpChannel instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)abstractAmqpChannel;
            lifecycle.start();
        }
    }

    public void stop() {
        AbstractAmqpChannel abstractAmqpChannel = this.channel;
        if (abstractAmqpChannel instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)abstractAmqpChannel;
            lifecycle.stop();
        }
    }

    public void stop(Runnable callback) {
        AbstractAmqpChannel abstractAmqpChannel = this.channel;
        if (abstractAmqpChannel instanceof SmartLifecycle) {
            SmartLifecycle smartLifecycle = (SmartLifecycle)abstractAmqpChannel;
            smartLifecycle.stop(callback);
        } else {
            callback.run();
        }
    }

    protected void destroyInstance(AbstractAmqpChannel instance) {
        this.channel.destroy();
    }
}

