/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.StringUtils;

public class DefaultJmsHeaderMapper
implements JmsHeaderMapper {
    private static List<Class<?>> SUPPORTED_PROPERTY_TYPES = Arrays.asList(Boolean.class, Byte.class, Double.class, Float.class, Integer.class, Long.class, Short.class, String.class);
    private final Log logger = LogFactory.getLog(this.getClass());
    private volatile String inboundPrefix = "";
    private volatile String outboundPrefix = "";
    private volatile boolean mapInboundPriority = true;

    public void setMapInboundPriority(boolean mapInboundPriority) {
        this.mapInboundPriority = mapInboundPriority;
    }

    public void setInboundPrefix(String inboundPrefix) {
        this.inboundPrefix = inboundPrefix != null ? inboundPrefix : "";
    }

    public void setOutboundPrefix(String outboundPrefix) {
        this.outboundPrefix = outboundPrefix != null ? outboundPrefix : "";
    }

    public void fromHeaders(MessageHeaders headers, Message jmsMessage) {
        block16: {
            try {
                Object jmsType;
                Object jmsReplyTo;
                Object jmsCorrelationId = headers.get((Object)"jms_correlationId");
                if (jmsCorrelationId instanceof Number) {
                    jmsCorrelationId = ((Number)jmsCorrelationId).toString();
                }
                if (jmsCorrelationId instanceof String) {
                    try {
                        jmsMessage.setJMSCorrelationID((String)jmsCorrelationId);
                    }
                    catch (Exception e) {
                        this.logger.info((Object)"failed to set JMSCorrelationID, skipping", (Throwable)e);
                    }
                }
                if ((jmsReplyTo = headers.get((Object)"jms_replyTo")) instanceof Destination) {
                    try {
                        jmsMessage.setJMSReplyTo((Destination)jmsReplyTo);
                    }
                    catch (Exception e) {
                        this.logger.info((Object)"failed to set JMSReplyTo, skipping", (Throwable)e);
                    }
                }
                if ((jmsType = headers.get((Object)"jms_type")) instanceof String) {
                    try {
                        jmsMessage.setJMSType((String)jmsType);
                    }
                    catch (Exception e) {
                        this.logger.info((Object)"failed to set JMSType, skipping", (Throwable)e);
                    }
                }
                for (Map.Entry entry : headers.entrySet()) {
                    Object value;
                    String headerName = (String)entry.getKey();
                    if (!StringUtils.hasText((String)headerName) || headerName.startsWith("jms_") || jmsMessage.getObjectProperty(headerName) != null || (value = entry.getValue()) == null || !SUPPORTED_PROPERTY_TYPES.contains(value.getClass())) continue;
                    try {
                        String propertyName = this.fromHeaderName(headerName);
                        jmsMessage.setObjectProperty(propertyName, value);
                    }
                    catch (Exception e) {
                        if (headerName.startsWith("JMSX") || headerName.equals("priority")) {
                            if (!this.logger.isTraceEnabled()) continue;
                            this.logger.trace((Object)("skipping reserved header, it cannot be set by client: " + headerName));
                            continue;
                        }
                        if (!this.logger.isWarnEnabled()) continue;
                        this.logger.warn((Object)("failed to map Message header '" + headerName + "' to JMS property"), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) break block16;
                this.logger.warn((Object)"error occurred while mapping from MessageHeaders to JMS properties", (Throwable)e);
            }
        }
    }

    public Map<String, Object> toHeaders(Message jmsMessage) {
        HashMap<String, Object> headers;
        block25: {
            headers = new HashMap<String, Object>();
            try {
                Enumeration jmsPropertyNames;
                try {
                    String messageId = jmsMessage.getJMSMessageID();
                    if (messageId != null) {
                        headers.put("jms_messageId", messageId);
                    }
                }
                catch (Exception e) {
                    this.logger.info((Object)"failed to read JMSMessageID property, skipping", (Throwable)e);
                }
                try {
                    String correlationId = jmsMessage.getJMSCorrelationID();
                    if (correlationId != null) {
                        headers.put("jms_correlationId", correlationId);
                    }
                }
                catch (Exception e) {
                    this.logger.info((Object)"failed to read JMSCorrelationID property, skipping", (Throwable)e);
                }
                try {
                    Destination replyTo = jmsMessage.getJMSReplyTo();
                    if (replyTo != null) {
                        headers.put("jms_replyTo", replyTo);
                    }
                }
                catch (Exception e) {
                    this.logger.info((Object)"failed to read JMSReplyTo property, skipping", (Throwable)e);
                }
                try {
                    headers.put("jms_redelivered", jmsMessage.getJMSRedelivered());
                }
                catch (Exception e) {
                    this.logger.info((Object)"failed to read JMSRedelivered property, skipping", (Throwable)e);
                }
                try {
                    String type = jmsMessage.getJMSType();
                    if (type != null) {
                        headers.put("jms_type", type);
                    }
                }
                catch (Exception e) {
                    this.logger.info((Object)"failed to read JMSType property, skipping", (Throwable)e);
                }
                try {
                    headers.put("jms_timestamp", jmsMessage.getJMSTimestamp());
                }
                catch (Exception e) {
                    this.logger.info((Object)"failed to read JMSTimestamp property, skipping", (Throwable)e);
                }
                if (this.mapInboundPriority) {
                    try {
                        headers.put("priority", jmsMessage.getJMSPriority());
                    }
                    catch (Exception e) {
                        this.logger.info((Object)"failed to read JMSPriority property, skipping", (Throwable)e);
                    }
                }
                if ((jmsPropertyNames = jmsMessage.getPropertyNames()) != null) {
                    while (jmsPropertyNames.hasMoreElements()) {
                        String propertyName = jmsPropertyNames.nextElement().toString();
                        try {
                            String headerName = this.toHeaderName(propertyName);
                            headers.put(headerName, jmsMessage.getObjectProperty(propertyName));
                        }
                        catch (Exception e) {
                            if (!this.logger.isWarnEnabled()) continue;
                            this.logger.warn((Object)("error occurred while mapping JMS property '" + propertyName + "' to Message header"), (Throwable)e);
                        }
                    }
                }
            }
            catch (JMSException e) {
                if (!this.logger.isWarnEnabled()) break block25;
                this.logger.warn((Object)"error occurred while mapping from JMS properties to MessageHeaders", (Throwable)e);
            }
        }
        return headers;
    }

    private String fromHeaderName(String headerName) {
        String propertyName = headerName;
        if (StringUtils.hasText((String)this.outboundPrefix) && !propertyName.startsWith(this.outboundPrefix)) {
            propertyName = this.outboundPrefix + headerName;
        } else if ("contentType".equals(headerName)) {
            propertyName = "content_type";
        }
        return propertyName;
    }

    private String toHeaderName(String propertyName) {
        String headerName = propertyName;
        if (StringUtils.hasText((String)this.inboundPrefix) && !headerName.startsWith(this.inboundPrefix)) {
            headerName = this.inboundPrefix + propertyName;
        } else if ("content_type".equals(propertyName)) {
            headerName = "contentType";
        }
        return headerName;
    }
}

