/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jmx.config;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.integration.config.IntegrationConfigurationInitializer;
import org.springframework.integration.jmx.config.MBeanExporterHelper;
import org.springframework.integration.monitor.IntegrationMBeanExporter;

public class JmxIntegrationConfigurationInitializer
implements IntegrationConfigurationInitializer {
    private static final String MBEAN_EXPORTER_HELPER_BEAN_NAME = MBeanExporterHelper.class.getName();

    public void initialize(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.registerMBeanExporterHelperIfNecessary(beanFactory);
    }

    private void registerMBeanExporterHelperIfNecessary(ConfigurableListableBeanFactory beanFactory) {
        if (beanFactory.getBeanNamesForType(IntegrationMBeanExporter.class, false, false).length > 0) {
            ((BeanDefinitionRegistry)beanFactory).registerBeanDefinition(MBEAN_EXPORTER_HELPER_BEAN_NAME, (BeanDefinition)new RootBeanDefinition(MBeanExporterHelper.class));
        }
    }
}

