/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.monitor;

import java.lang.annotation.Annotation;
import org.springframework.beans.annotation.AnnotationBeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.EmbeddedValueResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.integration.support.management.IntegrationManagedResource;
import org.springframework.jmx.export.annotation.AnnotationJmxAttributeSource;
import org.springframework.jmx.export.metadata.InvalidMetadataException;
import org.springframework.jmx.export.metadata.ManagedResource;
import org.springframework.util.StringValueResolver;

public class IntegrationJmxAttributeSource
extends AnnotationJmxAttributeSource {
    private StringValueResolver valueResolver;

    public void setValueResolver(StringValueResolver valueResolver) {
        this.valueResolver = valueResolver;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        super.setBeanFactory(beanFactory);
        if (beanFactory instanceof ConfigurableBeanFactory) {
            this.valueResolver = new EmbeddedValueResolver((ConfigurableBeanFactory)beanFactory);
        }
    }

    public ManagedResource getManagedResource(Class<?> beanClass) throws InvalidMetadataException {
        IntegrationManagedResource ann = (IntegrationManagedResource)AnnotationUtils.getAnnotation(beanClass, IntegrationManagedResource.class);
        if (ann == null) {
            return null;
        }
        ManagedResource managedResource = new ManagedResource();
        AnnotationBeanUtils.copyPropertiesToBean((Annotation)ann, (Object)managedResource, (StringValueResolver)this.valueResolver, (String[])new String[0]);
        return managedResource;
    }
}

