/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.channel;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.core.log.LogAccessor;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.kafka.core.KafkaOperations;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public abstract class AbstractKafkaChannel
extends AbstractMessageChannel {
    protected final LogAccessor logger;
    private final KafkaOperations<?, ?> template;
    protected final String topic;
    private String groupId;

    public AbstractKafkaChannel(KafkaOperations<?, ?> template, String topic) {
        this.logger = new LogAccessor(((AbstractMessageChannel)this).logger);
        Assert.notNull(template, (String)"'template' cannot be null");
        Assert.notNull((Object)topic, (String)"'topic' cannot be null");
        this.template = template;
        this.topic = topic;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    protected String getGroupId() {
        return this.groupId;
    }

    protected boolean doSend(Message<?> message, long timeout) {
        try {
            this.template.send(MessageBuilder.fromMessage(message).setHeader("kafka_topic", (Object)this.topic).build()).get(timeout < 0L ? Long.MAX_VALUE : timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.debug(() -> "Interrupted while waiting for send result for: " + message);
            return false;
        }
        catch (ExecutionException e) {
            this.logger.error(e.getCause(), () -> "Interrupted while waiting for send result for: " + message);
            return false;
        }
        catch (TimeoutException e) {
            this.logger.debug((Throwable)e, () -> "Timed out while waiting for send result for: " + message);
            return false;
        }
        return true;
    }
}

