/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.annotation;

import org.apache.kafka.streams.StreamsConfig;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.KStreamBuilderFactoryBean;

@Configuration
public class KafkaStreamsDefaultConfiguration {
    public static final String DEFAULT_STREAMS_CONFIG_BEAN_NAME = "defaultKafkaStreamsConfig";
    public static final String DEFAULT_KSTREAM_BUILDER_BEAN_NAME = "defaultKStreamBuilder";

    @Bean(name={"defaultKStreamBuilder"})
    public KStreamBuilderFactoryBean defaultKStreamBuilder(@Qualifier(value="defaultKafkaStreamsConfig") ObjectProvider<StreamsConfig> streamsConfigProvider) {
        StreamsConfig streamsConfig = (StreamsConfig)streamsConfigProvider.getIfAvailable();
        if (streamsConfig != null) {
            return new KStreamBuilderFactoryBean(streamsConfig);
        }
        throw new UnsatisfiedDependencyException(KafkaStreamsDefaultConfiguration.class.getName(), DEFAULT_KSTREAM_BUILDER_BEAN_NAME, "streamsConfig", "There is no 'defaultKafkaStreamsConfig' StreamsConfig bean in the application context.\nConsider to declare one or don't use @EnableKafkaStreams.");
    }
}

