/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.listener.adapter.AbstractMessageListenerAdapter;
import org.springframework.kafka.listener.adapter.RecordFilterStrategy;
import org.springframework.util.Assert;

public abstract class AbstractFilteringMessageListener<K, V, T>
extends AbstractMessageListenerAdapter<K, V, T> {
    private final RecordFilterStrategy<K, V> recordFilterStrategy;

    protected AbstractFilteringMessageListener(T delegate, RecordFilterStrategy<K, V> recordFilterStrategy) {
        super(delegate);
        Assert.notNull(recordFilterStrategy, (String)"'recordFilterStrategy' cannot be null");
        this.recordFilterStrategy = recordFilterStrategy;
    }

    protected boolean filter(ConsumerRecord<K, V> consumerRecord) {
        return this.recordFilterStrategy.filter(consumerRecord);
    }
}

