/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import java.lang.reflect.Method;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.listener.AcknowledgingMessageListener;
import org.springframework.kafka.listener.KafkaListenerErrorHandler;
import org.springframework.kafka.listener.ListenerExecutionFailedException;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.kafka.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.messaging.Message;

public class RecordMessagingMessageListenerAdapter<K, V>
extends MessagingMessageListenerAdapter<K, V>
implements MessageListener<K, V>,
AcknowledgingMessageListener<K, V> {
    private KafkaListenerErrorHandler errorHandler;

    public RecordMessagingMessageListenerAdapter(Object bean, Method method) {
        this(bean, method, null);
    }

    public RecordMessagingMessageListenerAdapter(Object bean, Method method, KafkaListenerErrorHandler errorHandler) {
        super(bean, method);
        this.errorHandler = errorHandler;
    }

    @Override
    public void onMessage(ConsumerRecord<K, V> record) {
        this.onMessage(record, (Acknowledgment)null);
    }

    @Override
    public void onMessage(ConsumerRecord<K, V> record, Acknowledgment acknowledgment) {
        Message<?> message = this.toMessagingMessage(record, acknowledgment);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Processing [" + message + "]"));
        }
        try {
            this.invokeHandler(record, acknowledgment, message);
        }
        catch (ListenerExecutionFailedException e) {
            if (this.errorHandler != null) {
                try {
                    this.errorHandler.handleError(message, e);
                }
                catch (Exception ex) {
                    throw new ListenerExecutionFailedException(this.createMessagingErrorMessage("Listener error handler threw an exception for the incoming message", message.getPayload()), ex);
                }
            }
            throw e;
        }
    }
}

