/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.springframework.util.Assert;

public final class LogIfLevelEnabled {
    private final Log logger;
    private final Level level;

    public LogIfLevelEnabled(Log logger, Level level) {
        Assert.notNull((Object)logger, (String)"'logger' cannot be null");
        Assert.notNull((Object)((Object)level), (String)"'level' cannot be null");
        this.logger = logger;
        this.level = level;
    }

    public void log(Supplier<Object> messageSupplier) {
        switch (this.level) {
            case FATAL: {
                if (!this.logger.isFatalEnabled()) break;
                this.logger.fatal(messageSupplier.get());
                break;
            }
            case ERROR: {
                if (!this.logger.isErrorEnabled()) break;
                this.logger.error(messageSupplier.get());
                break;
            }
            case WARN: {
                if (!this.logger.isWarnEnabled()) break;
                this.logger.warn(messageSupplier.get());
                break;
            }
            case INFO: {
                if (!this.logger.isInfoEnabled()) break;
                this.logger.info(messageSupplier.get());
                break;
            }
            case DEBUG: {
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug(messageSupplier.get());
                break;
            }
            case TRACE: {
                if (!this.logger.isTraceEnabled()) break;
                this.logger.trace(messageSupplier.get());
            }
        }
    }

    public void log(Supplier<Object> messageSupplier, Throwable t) {
        switch (this.level) {
            case FATAL: {
                if (!this.logger.isFatalEnabled()) break;
                this.logger.fatal(messageSupplier.get(), t);
                break;
            }
            case ERROR: {
                if (!this.logger.isErrorEnabled()) break;
                this.logger.error(messageSupplier.get(), t);
                break;
            }
            case WARN: {
                if (!this.logger.isWarnEnabled()) break;
                this.logger.warn(messageSupplier.get(), t);
                break;
            }
            case INFO: {
                if (!this.logger.isInfoEnabled()) break;
                this.logger.info(messageSupplier.get(), t);
                break;
            }
            case DEBUG: {
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug(messageSupplier.get(), t);
                break;
            }
            case TRACE: {
                if (!this.logger.isTraceEnabled()) break;
                this.logger.trace(messageSupplier.get(), t);
            }
        }
    }

    public static enum Level {
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

