/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.function.BiConsumer;
import org.apache.commons.logging.Log;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.lang.Nullable;

class FailedRecordTracker {
    private final ThreadLocal<FailedRecord> failures = new ThreadLocal();
    private final BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer;
    private final int maxFailures;

    FailedRecordTracker(@Nullable BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer, int maxFailures, Log logger) {
        this.recoverer = recoverer == null ? (r, t) -> logger.error((Object)("Max failures (" + maxFailures + ") reached for: " + r), (Throwable)t) : recoverer;
        this.maxFailures = maxFailures;
    }

    boolean skip(ConsumerRecord<?, ?> record, Exception exception) {
        FailedRecord failedRecord = this.failures.get();
        if (failedRecord == null || !failedRecord.getTopic().equals(record.topic()) || failedRecord.getPartition() != record.partition() || failedRecord.getOffset() != record.offset()) {
            this.failures.set(new FailedRecord(record.topic(), record.partition(), record.offset()));
            return false;
        }
        if (failedRecord.incrementAndGet() >= this.maxFailures) {
            this.recoverer.accept(record, exception);
            return true;
        }
        return false;
    }

    void clearThreadState() {
        this.failures.remove();
    }

    private static final class FailedRecord {
        private final String topic;
        private final int partition;
        private final long offset;
        private int count;

        FailedRecord(String topic, int partition, long offset) {
            this.topic = topic;
            this.partition = partition;
            this.offset = offset;
            this.count = 1;
        }

        private String getTopic() {
            return this.topic;
        }

        private int getPartition() {
            return this.partition;
        }

        private long getOffset() {
            return this.offset;
        }

        private int incrementAndGet() {
            return ++this.count;
        }
    }
}

