/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.kafka.support.KafkaHeaderMapper;
import org.springframework.util.Assert;
import org.springframework.util.PatternMatchUtils;

public abstract class AbstractKafkaHeaderMapper
implements KafkaHeaderMapper {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final List<SimplePatternBasedHeaderMatcher> NEVER_MAPPED = Arrays.asList(new SimplePatternBasedHeaderMatcher("!kafka_acknowledgment"), new SimplePatternBasedHeaderMatcher("!kafka_consumer"), new SimplePatternBasedHeaderMatcher("!kafka_messageKey"), new SimplePatternBasedHeaderMatcher("!kafka_offset"), new SimplePatternBasedHeaderMatcher("!kafka_partitionId"), new SimplePatternBasedHeaderMatcher("!kafka_data"), new SimplePatternBasedHeaderMatcher("!kafka_receivedMessageKey"), new SimplePatternBasedHeaderMatcher("!kafka_receivedPartitionId"), new SimplePatternBasedHeaderMatcher("!kafka_receivedTimestamp"), new SimplePatternBasedHeaderMatcher("!kafka_receivedTopic"), new SimplePatternBasedHeaderMatcher("!kafka_timestamp"), new SimplePatternBasedHeaderMatcher("!kafka_timestampType"), new SimplePatternBasedHeaderMatcher("!kafka_batchConvertedHeaders"), new SimplePatternBasedHeaderMatcher("!kafka_nativeHeaders"), new SimplePatternBasedHeaderMatcher("!kafka_topic"));
    protected final List<SimplePatternBasedHeaderMatcher> matchers = new ArrayList<SimplePatternBasedHeaderMatcher>(NEVER_MAPPED);

    public AbstractKafkaHeaderMapper(String ... patterns) {
        Assert.notNull((Object)patterns, (String)"'patterns' must not be null");
        for (String pattern : patterns) {
            this.matchers.add(new SimplePatternBasedHeaderMatcher(pattern));
        }
    }

    protected boolean matches(String header, Object value) {
        if (this.matches(header)) {
            if ((header.equals("replyChannel") || header.equals("errorChannel")) && !(value instanceof String)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Cannot map " + header + " when type is [" + value.getClass() + "]; it must be a String"));
                }
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean matches(String header) {
        for (SimplePatternBasedHeaderMatcher matcher : this.matchers) {
            if (!matcher.matchHeader(header)) continue;
            return !matcher.isNegated();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)MessageFormat.format("headerName=[{0}] WILL NOT be mapped; matched no patterns", header));
        }
        return false;
    }

    protected static class SimplePatternBasedHeaderMatcher {
        private static final Log logger = LogFactory.getLog(SimplePatternBasedHeaderMatcher.class);
        private final String pattern;
        private final boolean negate;

        public SimplePatternBasedHeaderMatcher(String pattern) {
            this(pattern.startsWith("!") ? pattern.substring(1) : pattern, pattern.startsWith("!"));
        }

        SimplePatternBasedHeaderMatcher(String pattern, boolean negate) {
            Assert.notNull((Object)pattern, (String)"Pattern must no be null");
            this.pattern = pattern.toLowerCase();
            this.negate = negate;
        }

        public boolean matchHeader(String headerName) {
            String header = headerName.toLowerCase();
            if (PatternMatchUtils.simpleMatch((String)this.pattern, (String)header)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)MessageFormat.format("headerName=[{0}] WILL " + (this.negate ? "NOT " : "") + "be mapped, matched pattern=" + (this.negate ? "!" : "") + "{1}", headerName, this.pattern));
                }
                return true;
            }
            return false;
        }

        public boolean isNegated() {
            return this.negate;
        }
    }
}

