/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.springframework.core.log.LogAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.BackOffExecution;

class FailedRecordTracker {
    private final ThreadLocal<Map<TopicPartition, FailedRecord>> failures = new ThreadLocal();
    private final BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer;
    private final boolean noRetries;
    private final BackOff backOff;

    FailedRecordTracker(@Nullable BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer, BackOff backOff, LogAccessor logger) {
        Assert.notNull((Object)backOff, (String)"'backOff' cannot be null");
        this.recoverer = recoverer == null ? (rec, thr) -> {
            Map<TopicPartition, FailedRecord> map = this.failures.get();
            FailedRecord failedRecord = null;
            if (map != null) {
                failedRecord = map.get(new TopicPartition(rec.topic(), rec.partition()));
            }
            logger.error((Throwable)thr, (CharSequence)("Backoff " + (failedRecord == null ? "none" : failedRecord.getBackOffExecution()) + " exhausted for " + rec));
        } : recoverer;
        this.noRetries = backOff.start().nextBackOff() == -1L;
        this.backOff = backOff;
    }

    boolean skip(ConsumerRecord<?, ?> record, Exception exception) {
        long nextBackOff;
        TopicPartition topicPartition;
        FailedRecord failedRecord;
        if (this.noRetries) {
            this.recoverer.accept(record, exception);
            return true;
        }
        Map<TopicPartition, FailedRecord> map = this.failures.get();
        if (map == null) {
            this.failures.set(new HashMap());
            map = this.failures.get();
        }
        if ((failedRecord = map.get(topicPartition = new TopicPartition(record.topic(), record.partition()))) == null || failedRecord.getOffset() != record.offset()) {
            failedRecord = new FailedRecord(record.offset(), this.backOff.start());
            map.put(topicPartition, failedRecord);
        }
        if ((nextBackOff = failedRecord.getBackOffExecution().nextBackOff()) != -1L) {
            try {
                Thread.sleep(nextBackOff);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return false;
        }
        this.recoverer.accept(record, exception);
        map.remove(topicPartition);
        if (map.isEmpty()) {
            this.failures.remove();
        }
        return true;
    }

    void clearThreadState() {
        this.failures.remove();
    }

    BiConsumer<ConsumerRecord<?, ?>, Exception> getRecoverer() {
        return this.recoverer;
    }

    private static final class FailedRecord {
        private final long offset;
        private final BackOffExecution backOffExecution;

        FailedRecord(long offset, BackOffExecution backOffExecution) {
            this.offset = offset;
            this.backOffExecution = backOffExecution;
        }

        long getOffset() {
            return this.offset;
        }

        BackOffExecution getBackOffExecution() {
            return this.backOffExecution;
        }
    }
}

