/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.support.SendResult;
import org.springframework.messaging.Message;
import org.springframework.util.concurrent.ListenableFuture;

public interface KafkaOperations<K, V> {
    public ListenableFuture<SendResult<K, V>> sendDefault(V var1);

    public ListenableFuture<SendResult<K, V>> sendDefault(K var1, V var2);

    public ListenableFuture<SendResult<K, V>> sendDefault(Integer var1, K var2, V var3);

    public ListenableFuture<SendResult<K, V>> sendDefault(Integer var1, Long var2, K var3, V var4);

    public ListenableFuture<SendResult<K, V>> send(String var1, V var2);

    public ListenableFuture<SendResult<K, V>> send(String var1, K var2, V var3);

    public ListenableFuture<SendResult<K, V>> send(String var1, Integer var2, K var3, V var4);

    public ListenableFuture<SendResult<K, V>> send(String var1, Integer var2, Long var3, K var4, V var5);

    public ListenableFuture<SendResult<K, V>> send(ProducerRecord<K, V> var1);

    public ListenableFuture<SendResult<K, V>> send(Message<?> var1);

    public List<PartitionInfo> partitionsFor(String var1);

    public Map<MetricName, ? extends Metric> metrics();

    public <T> T execute(ProducerCallback<K, V, T> var1);

    public <T> T executeInTransaction(OperationsCallback<K, V, T> var1);

    public void flush();

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> var1);

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> var1, String var2);

    default public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, ConsumerGroupMetadata groupMetadata) {
        throw new UnsupportedOperationException();
    }

    public boolean isTransactional();

    default public boolean isAllowNonTransactional() {
        return false;
    }

    default public boolean inTransaction() {
        return false;
    }

    default public ProducerFactory<K, V> getProducerFactory() {
        throw new UnsupportedOperationException("This implementation does not support this operation");
    }

    public static interface OperationsCallback<K, V, T> {
        public T doInOperations(KafkaOperations<K, V> var1);
    }

    public static interface ProducerCallback<K, V, T> {
        public T doInKafka(Producer<K, V> var1);
    }
}

