/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.retrytopic;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class EndpointHandlerMethod {
    private final Class<?> beanClass;
    private final Method method;
    private Object bean;

    public EndpointHandlerMethod(Class<?> beanClass, String methodName) {
        Assert.notNull(beanClass, () -> "No destination bean class provided!");
        Assert.notNull((Object)methodName, () -> "No method name for destination bean class provided!");
        this.method = Arrays.stream(ReflectionUtils.getDeclaredMethods(beanClass)).filter(mthd -> mthd.getName().equals(methodName)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("No method %s in class %s", methodName, beanClass)));
        this.beanClass = beanClass;
    }

    public EndpointHandlerMethod(Object bean, Method method) {
        Assert.notNull((Object)bean, () -> "No bean for destination provided!");
        Assert.notNull((Object)method, () -> "No method for destination bean class provided!");
        this.method = method;
        this.bean = bean;
        this.beanClass = bean.getClass();
    }

    public Method getMethod() {
        return this.method;
    }

    public Object resolveBean(BeanFactory beanFactory) {
        if (this.bean == null) {
            try {
                this.bean = beanFactory.getBean(this.beanClass);
            }
            catch (NoSuchBeanDefinitionException e) {
                String beanName = this.beanClass.getSimpleName() + "-handlerMethod";
                ((BeanDefinitionRegistry)beanFactory).registerBeanDefinition(beanName, (BeanDefinition)new RootBeanDefinition(this.beanClass));
                this.bean = beanFactory.getBean(beanName);
            }
        }
        return this.bean;
    }
}

