/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.kafka.listener.ConsumerProperties;
import org.springframework.kafka.support.TopicPartitionOffset;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class ContainerProperties
extends ConsumerProperties {
    public static final long DEFAULT_SHUTDOWN_TIMEOUT = 10000L;
    public static final int DEFAULT_MONITOR_INTERVAL = 30;
    public static final float DEFAULT_NO_POLL_THRESHOLD = 3.0f;
    private static final Duration DEFAULT_CONSUMER_START_TIMEOUT = Duration.ofSeconds(30L);
    private static final int DEFAULT_ACK_TIME = 5000;
    private static final double DEFAULT_IDLE_BEFORE_DATA_MULTIPLIER = 5.0;
    private final Map<String, String> micrometerTags = new HashMap<String, String>();
    private final List<Advice> adviceChain = new ArrayList<Advice>();
    private AckMode ackMode = AckMode.BATCH;
    private int ackCount = 1;
    private long ackTime = 5000L;
    private Object messageListener;
    private AsyncListenableTaskExecutor consumerTaskExecutor;
    private long shutdownTimeout = 10000L;
    private Long idleEventInterval;
    private Long idlePartitionEventInterval;
    private double idleBeforeDataMultiplier = 5.0;
    private PlatformTransactionManager transactionManager;
    private int monitorInterval = 30;
    private TaskScheduler scheduler;
    private float noPollThreshold = 3.0f;
    private boolean logContainerConfig;
    private boolean missingTopicsFatal = false;
    private long idleBetweenPolls;
    private boolean micrometerEnabled = true;
    private Duration consumerStartTimeout = DEFAULT_CONSUMER_START_TIMEOUT;
    private Boolean subBatchPerPartition;
    private AssignmentCommitOption assignmentCommitOption = AssignmentCommitOption.LATEST_ONLY_NO_TX;
    private boolean deliveryAttemptHeader;
    private EOSMode eosMode = EOSMode.V2;
    private TransactionDefinition transactionDefinition;
    private boolean stopContainerWhenFenced;
    private boolean stopImmediate;
    private boolean asyncAcks;

    public ContainerProperties(String ... topics) {
        super(topics);
    }

    public ContainerProperties(Pattern topicPattern) {
        super(topicPattern);
    }

    public ContainerProperties(TopicPartitionOffset ... topicPartitions) {
        super(topicPartitions);
    }

    public void setMessageListener(Object messageListener) {
        this.messageListener = messageListener;
        this.adviseListenerIfNeeded();
    }

    public void setAckMode(AckMode ackMode) {
        Assert.notNull((Object)((Object)ackMode), (String)"'ackMode' cannot be null");
        this.ackMode = ackMode;
    }

    public void setAckCount(int count) {
        Assert.state((count > 0 ? 1 : 0) != 0, (String)"'ackCount' must be > 0");
        this.ackCount = count;
    }

    public void setAckTime(long ackTime) {
        Assert.state((ackTime > 0L ? 1 : 0) != 0, (String)"'ackTime' must be > 0");
        this.ackTime = ackTime;
    }

    public void setConsumerTaskExecutor(@Nullable AsyncListenableTaskExecutor consumerTaskExecutor) {
        this.consumerTaskExecutor = consumerTaskExecutor;
    }

    public void setShutdownTimeout(long shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    @Override
    public void setSyncCommitTimeout(@Nullable Duration syncCommitTimeout) {
        super.setSyncCommitTimeout(syncCommitTimeout);
    }

    public void setIdleEventInterval(@Nullable Long idleEventInterval) {
        this.idleEventInterval = idleEventInterval;
    }

    public void setIdleBeforeDataMultiplier(double idleBeforeDataMultiplier) {
        this.idleBeforeDataMultiplier = idleBeforeDataMultiplier;
    }

    public void setIdlePartitionEventInterval(@Nullable Long idlePartitionEventInterval) {
        this.idlePartitionEventInterval = idlePartitionEventInterval;
    }

    public AckMode getAckMode() {
        return this.ackMode;
    }

    public int getAckCount() {
        return this.ackCount;
    }

    public long getAckTime() {
        return this.ackTime;
    }

    public Object getMessageListener() {
        return this.messageListener;
    }

    @Nullable
    public AsyncListenableTaskExecutor getConsumerTaskExecutor() {
        return this.consumerTaskExecutor;
    }

    public long getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    @Nullable
    public Long getIdleEventInterval() {
        return this.idleEventInterval;
    }

    public double getIdleBeforeDataMultiplier() {
        return this.idleBeforeDataMultiplier;
    }

    @Nullable
    public Long getIdlePartitionEventInterval() {
        return this.idlePartitionEventInterval;
    }

    @Nullable
    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(@Nullable PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public int getMonitorInterval() {
        return this.monitorInterval;
    }

    public void setMonitorInterval(int monitorInterval) {
        this.monitorInterval = monitorInterval;
    }

    @Nullable
    public TaskScheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(@Nullable TaskScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public float getNoPollThreshold() {
        return this.noPollThreshold;
    }

    public void setNoPollThreshold(float noPollThreshold) {
        this.noPollThreshold = noPollThreshold;
    }

    public boolean isLogContainerConfig() {
        return this.logContainerConfig;
    }

    public void setLogContainerConfig(boolean logContainerConfig) {
        this.logContainerConfig = logContainerConfig;
    }

    public boolean isMissingTopicsFatal() {
        return this.missingTopicsFatal;
    }

    public void setMissingTopicsFatal(boolean missingTopicsFatal) {
        this.missingTopicsFatal = missingTopicsFatal;
    }

    public void setIdleBetweenPolls(long idleBetweenPolls) {
        this.idleBetweenPolls = idleBetweenPolls;
    }

    public long getIdleBetweenPolls() {
        return this.idleBetweenPolls;
    }

    public boolean isMicrometerEnabled() {
        return this.micrometerEnabled;
    }

    public void setMicrometerEnabled(boolean micrometerEnabled) {
        this.micrometerEnabled = micrometerEnabled;
    }

    public void setMicrometerTags(Map<String, String> tags) {
        if (tags != null) {
            this.micrometerTags.putAll(tags);
        }
    }

    public Map<String, String> getMicrometerTags() {
        return Collections.unmodifiableMap(this.micrometerTags);
    }

    public Duration getConsumerStartTimeout() {
        return this.consumerStartTimeout;
    }

    @Deprecated
    public Duration getConsumerStartTimout() {
        return this.consumerStartTimeout;
    }

    public void setConsumerStartTimeout(Duration consumerStartTimeout) {
        Assert.notNull((Object)consumerStartTimeout, (String)"'consumerStartTimout' cannot be null");
        this.consumerStartTimeout = consumerStartTimeout;
    }

    @Deprecated
    public void setConsumerStartTimout(Duration consumerStartTimeout) {
        this.setConsumerStartTimeout(consumerStartTimeout);
    }

    public boolean isSubBatchPerPartition() {
        return this.subBatchPerPartition == null ? false : this.subBatchPerPartition;
    }

    @Nullable
    public Boolean getSubBatchPerPartition() {
        return this.subBatchPerPartition;
    }

    public void setSubBatchPerPartition(@Nullable Boolean subBatchPerPartition) {
        this.subBatchPerPartition = subBatchPerPartition;
    }

    public AssignmentCommitOption getAssignmentCommitOption() {
        return this.assignmentCommitOption;
    }

    public void setAssignmentCommitOption(AssignmentCommitOption assignmentCommitOption) {
        Assert.notNull((Object)((Object)assignmentCommitOption), (String)"'assignmentCommitOption' cannot be null");
        this.assignmentCommitOption = assignmentCommitOption;
    }

    public boolean isDeliveryAttemptHeader() {
        return this.deliveryAttemptHeader;
    }

    public void setDeliveryAttemptHeader(boolean deliveryAttemptHeader) {
        this.deliveryAttemptHeader = deliveryAttemptHeader;
    }

    public EOSMode getEosMode() {
        return this.eosMode;
    }

    public void setEosMode(EOSMode eosMode) {
        Assert.notNull((Object)((Object)eosMode), (String)"'eosMode' cannot be null");
        this.eosMode = eosMode;
    }

    @Nullable
    public TransactionDefinition getTransactionDefinition() {
        return this.transactionDefinition;
    }

    public void setTransactionDefinition(@Nullable TransactionDefinition transactionDefinition) {
        this.transactionDefinition = transactionDefinition;
    }

    public Advice[] getAdviceChain() {
        return this.adviceChain.toArray(new Advice[0]);
    }

    public void setAdviceChain(Advice ... adviceChain) {
        Assert.notNull((Object)adviceChain, (String)"'adviceChain' cannot be null");
        Assert.noNullElements((Object[])adviceChain, (String)"'adviceChain' cannot have null elements");
        this.adviceChain.clear();
        this.adviceChain.addAll(Arrays.asList(adviceChain));
        if (this.messageListener != null) {
            this.adviseListenerIfNeeded();
        }
    }

    public boolean isStopContainerWhenFenced() {
        return this.stopContainerWhenFenced;
    }

    public void setStopContainerWhenFenced(boolean stopContainerWhenFenced) {
        this.stopContainerWhenFenced = stopContainerWhenFenced;
    }

    public boolean isStopImmediate() {
        return this.stopImmediate;
    }

    public void setStopImmediate(boolean stopImmediate) {
        this.stopImmediate = stopImmediate;
    }

    public boolean isAsyncAcks() {
        return this.asyncAcks;
    }

    public void setAsyncAcks(boolean asyncAcks) {
        this.asyncAcks = asyncAcks;
    }

    private void adviseListenerIfNeeded() {
        if (!CollectionUtils.isEmpty(this.adviceChain)) {
            if (AopUtils.isAopProxy((Object)this.messageListener)) {
                Advised advised = (Advised)this.messageListener;
                this.adviceChain.forEach(arg_0 -> ((Advised)advised).removeAdvice(arg_0));
                this.adviceChain.forEach(arg_0 -> ((Advised)advised).addAdvice(arg_0));
            } else {
                ProxyFactory pf = new ProxyFactory(this.messageListener);
                this.adviceChain.forEach(arg_0 -> ((ProxyFactory)pf).addAdvice(arg_0));
                this.messageListener = pf.getProxy();
            }
        }
    }

    @Override
    public String toString() {
        return "ContainerProperties [" + this.renderProperties() + "\n ackMode=" + (Object)((Object)this.ackMode) + "\n ackCount=" + this.ackCount + "\n ackTime=" + this.ackTime + "\n messageListener=" + this.messageListener + (this.consumerTaskExecutor != null ? "\n consumerTaskExecutor=" + this.consumerTaskExecutor : "") + "\n shutdownTimeout=" + this.shutdownTimeout + "\n idleEventInterval=" + (this.idleEventInterval == null ? "not enabled" : this.idleEventInterval) + "\n idlePartitionEventInterval=" + (this.idlePartitionEventInterval == null ? "not enabled" : this.idlePartitionEventInterval) + (this.transactionManager != null ? "\n transactionManager=" + this.transactionManager : "") + "\n monitorInterval=" + this.monitorInterval + (this.scheduler != null ? "\n scheduler=" + this.scheduler : "") + "\n noPollThreshold=" + this.noPollThreshold + "\n subBatchPerPartition=" + this.subBatchPerPartition + "\n assignmentCommitOption=" + (Object)((Object)this.assignmentCommitOption) + "\n deliveryAttemptHeader=" + this.deliveryAttemptHeader + "\n eosMode=" + (Object)((Object)this.eosMode) + "\n transactionDefinition=" + this.transactionDefinition + "\n stopContainerWhenFenced=" + this.stopContainerWhenFenced + "\n stopImmediate=" + this.stopImmediate + "\n asyncAcks=" + this.asyncAcks + "\n idleBeforeDataMultiplier" + this.idleBeforeDataMultiplier + "\n]";
    }

    public static enum EOSMode {
        V1,
        V2,
        ALPHA(V1),
        BETA(V2);

        private final EOSMode mode;

        private EOSMode() {
            this.mode = this;
        }

        private EOSMode(EOSMode v12) {
            this.mode = v12;
        }

        public EOSMode getMode() {
            return this.mode;
        }
    }

    public static enum AssignmentCommitOption {
        ALWAYS,
        NEVER,
        LATEST_ONLY,
        LATEST_ONLY_NO_TX;

    }

    public static enum AckMode {
        RECORD,
        BATCH,
        TIME,
        COUNT,
        COUNT_TIME,
        MANUAL,
        MANUAL_IMMEDIATE;

    }
}

