/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.kafka.listener.adapter.ConsumerRecordMetadata;
import org.springframework.lang.Nullable;

public final class AdapterUtils {
    public static final ParserContext PARSER_CONTEXT = new TemplateParserContext("!{", "}");

    private AdapterUtils() {
    }

    @Nullable
    public static Object buildConsumerRecordMetadataFromArray(Object ... data) {
        for (Object object : data) {
            ConsumerRecordMetadata metadata = AdapterUtils.buildConsumerRecordMetadata(object);
            if (metadata == null) continue;
            return metadata;
        }
        return null;
    }

    @Nullable
    public static ConsumerRecordMetadata buildConsumerRecordMetadata(Object data) {
        if (!(data instanceof ConsumerRecord)) {
            return null;
        }
        ConsumerRecord record = (ConsumerRecord)data;
        return new ConsumerRecordMetadata(new RecordMetadata(new TopicPartition(record.topic(), record.partition()), record.offset(), 0, record.timestamp(), record.serializedKeySize(), record.serializedValueSize()), record.timestampType());
    }

    public static String getDefaultReplyTopicExpression() {
        return PARSER_CONTEXT.getExpressionPrefix() + "source.headers['kafka_replyTopic']" + PARSER_CONTEXT.getExpressionSuffix();
    }
}

