/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.springframework.kafka.event.KafkaEvent;

public class NonResponsiveConsumerEvent
extends KafkaEvent {
    private static final long serialVersionUID = 1L;
    private final long timeSinceLastPoll;
    private final String listenerId;
    private final List<TopicPartition> topicPartitions;
    private transient Consumer<?, ?> consumer;

    public NonResponsiveConsumerEvent(Object source, Object container, long timeSinceLastPoll, String id, Collection<TopicPartition> topicPartitions, Consumer<?, ?> consumer) {
        super(source, container);
        this.timeSinceLastPoll = timeSinceLastPoll;
        this.listenerId = id;
        this.topicPartitions = topicPartitions == null ? null : new ArrayList<TopicPartition>(topicPartitions);
        this.consumer = consumer;
    }

    public long getTimeSinceLastPoll() {
        return this.timeSinceLastPoll;
    }

    public Collection<TopicPartition> getTopicPartitions() {
        return this.topicPartitions == null ? null : Collections.unmodifiableList(this.topicPartitions);
    }

    public String getListenerId() {
        return this.listenerId;
    }

    public Consumer<?, ?> getConsumer() {
        return this.consumer;
    }

    public String toString() {
        return "NonResponsiveConsumerEvent [timeSinceLastPoll=" + (float)this.timeSinceLastPoll / 1000.0f + "s, listenerId=" + this.listenerId + ", container=" + String.valueOf(this.getSource()) + ", topicPartitions=" + String.valueOf(this.topicPartitions) + "]";
    }
}

