/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.common.header.Header;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.support.KafkaHeaderMapper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;

public abstract class AbstractKafkaHeaderMapper
implements KafkaHeaderMapper {
    private static final String[] DEFAULT_RAW_MAPPED_HEADERS = new String[]{"kafka_listenerInfo", "b3", "traceparent", "X-B3-TraceId", "X-B3-SpanId", "X-B3-Sampled", "X-B3-Flags"};
    protected final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    private final List<HeaderMatcher> matchers = new ArrayList<HeaderMatcher>();
    private final Map<String, Boolean> rawMappedHeaders = new HashMap<String, Boolean>();
    private final boolean outbound;
    private boolean mapAllStringsOut;
    private Charset charset;

    public AbstractKafkaHeaderMapper(String ... patterns) {
        this(true, patterns);
    }

    protected AbstractKafkaHeaderMapper(boolean outbound, String ... patterns) {
        for (String defaultRawMappedHeader : DEFAULT_RAW_MAPPED_HEADERS) {
            this.rawMappedHeaders.put(defaultRawMappedHeader, true);
        }
        this.charset = StandardCharsets.UTF_8;
        Assert.notNull((Object)patterns, (String)"'patterns' must not be null");
        this.outbound = outbound;
        if (outbound) {
            this.matchers.add(new NeverMatchHeaderMatcher("kafka_acknowledgment", "kafka_consumer", "kafka_messageKey", "kafka_offset", "kafka_partitionId", "kafka_data", "kafka_receivedMessageKey", "kafka_receivedPartitionId", "kafka_receivedTimestamp", "kafka_receivedTopic", "kafka_timestamp", "kafka_timestampType", "kafka_batchConvertedHeaders", "kafka_nativeHeaders", "kafka_topic", "kafka_deliveryAttempt", "kafka_listenerInfo", "kafka_groupId"));
        }
        for (String pattern : patterns) {
            this.matchers.add(new SimplePatternBasedHeaderMatcher(pattern));
        }
    }

    protected final void addMatchers(HeaderMatcher ... matchersToAdd) {
        Assert.notNull((Object)matchersToAdd, (String)"'matchersToAdd' cannot be null");
        Assert.noNullElements((Object[])matchersToAdd, (String)"'matchersToAdd' cannot have null elements");
        Collections.addAll(this.matchers, matchersToAdd);
    }

    public void setMapAllStringsOut(boolean mapAllStringsOut) {
        this.mapAllStringsOut = mapAllStringsOut;
    }

    protected Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        Assert.notNull((Object)charset, (String)"'charset' cannot be null");
        this.charset = charset;
    }

    public void setRawMappedHeaders(Map<String, Boolean> rawMappedHeaders) {
        if (!ObjectUtils.isEmpty(rawMappedHeaders)) {
            this.rawMappedHeaders.putAll(rawMappedHeaders);
        }
    }

    public void addRawMappedHeader(String name, boolean toString) {
        this.rawMappedHeaders.put(name, toString);
    }

    protected boolean matches(String header, Object value) {
        if (this.matches(header)) {
            if ((header.equals("replyChannel") || header.equals("errorChannel")) && !(value instanceof String)) {
                this.logger.debug(() -> "Cannot map " + header + " when type is [" + String.valueOf(value.getClass()) + "]; it must be a String");
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean matches(String header) {
        Assert.state((boolean)this.outbound, (String)"This mapper cannot be used for outbound mapping");
        return this.doesMatch(header);
    }

    protected boolean matchesForInbound(String header) {
        if (this.outbound) {
            return true;
        }
        if (this.matchers.isEmpty()) {
            return true;
        }
        return this.doesMatch(header);
    }

    private boolean doesMatch(String header) {
        for (HeaderMatcher matcher : this.matchers) {
            if (!matcher.matchHeader(header)) continue;
            return !matcher.isNegated();
        }
        this.logger.debug(() -> MessageFormat.format("headerName=[{0}] WILL NOT be mapped; matched no patterns", header));
        return false;
    }

    protected Object headerValueToAddOut(String key, Object value) {
        Object valueToAdd = this.mapRawOut(key, value);
        if (valueToAdd == null) {
            valueToAdd = value;
        }
        return valueToAdd;
    }

    @Nullable
    private byte[] mapRawOut(String header, Object value) {
        if (this.mapAllStringsOut || this.rawMappedHeaders.containsKey(header)) {
            if (value instanceof byte[]) {
                return (byte[])value;
            }
            if (value instanceof String) {
                return ((String)value).getBytes(this.charset);
            }
        }
        return null;
    }

    protected Object headerValueToAddIn(Header header) {
        if (header == null || header.value() == null) {
            return null;
        }
        String mapped = this.mapRawIn(header.key(), header.value());
        return mapped != null ? mapped : (Object)header.value();
    }

    @Nullable
    private String mapRawIn(String header, byte[] value) {
        Boolean asString = this.rawMappedHeaders.get(header);
        if (Boolean.TRUE.equals(asString)) {
            return new String(value, this.charset);
        }
        return null;
    }

    protected static class NeverMatchHeaderMatcher
    implements HeaderMatcher {
        private final Set<String> neverMatchHeaders;

        protected NeverMatchHeaderMatcher(String ... headers) {
            this.neverMatchHeaders = Arrays.stream(headers).collect(Collectors.toSet());
        }

        @Override
        public boolean matchHeader(String headerName) {
            return this.neverMatchHeaders.contains(headerName);
        }

        @Override
        public boolean isNegated() {
            return true;
        }
    }

    protected static class SimplePatternBasedHeaderMatcher
    implements HeaderMatcher {
        private static final LogAccessor LOGGER = new LogAccessor(LogFactory.getLog(SimplePatternBasedHeaderMatcher.class));
        private final String pattern;
        private final boolean negate;

        protected SimplePatternBasedHeaderMatcher(String pattern) {
            this(pattern.startsWith("!") ? pattern.substring(1) : pattern, pattern.startsWith("!"));
        }

        SimplePatternBasedHeaderMatcher(String pattern, boolean negate) {
            Assert.notNull((Object)pattern, (String)"Pattern must no be null");
            this.pattern = pattern.toLowerCase(Locale.ROOT);
            this.negate = negate;
        }

        @Override
        public boolean matchHeader(String headerName) {
            String header = headerName.toLowerCase(Locale.ROOT);
            if (PatternMatchUtils.simpleMatch((String)this.pattern, (String)header)) {
                LOGGER.debug(() -> MessageFormat.format("headerName=[{0}] WILL " + (this.negate ? "NOT " : "") + "be mapped, matched pattern=" + (this.negate ? "!" : "") + "{1}", headerName, this.pattern));
                return true;
            }
            return false;
        }

        @Override
        public boolean isNegated() {
            return this.negate;
        }
    }

    protected static interface HeaderMatcher {
        public boolean matchHeader(String var1);

        public boolean isNegated();
    }
}

