/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.client;

import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.NoSuchClientException;

public class ClientDetailsUserDetailsService
implements UserDetailsService {
    private final ClientDetailsService clientDetailsService;
    private String emptyPassword = "";

    public ClientDetailsUserDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.emptyPassword = passwordEncoder.encode((CharSequence)"");
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        ClientDetails clientDetails;
        try {
            clientDetails = this.clientDetailsService.loadClientByClientId(username);
        }
        catch (NoSuchClientException e) {
            throw new UsernameNotFoundException(e.getMessage(), (Throwable)e);
        }
        String clientSecret = clientDetails.getClientSecret();
        if (clientSecret == null || clientSecret.trim().length() == 0) {
            clientSecret = this.emptyPassword;
        }
        return new User(username, clientSecret, clientDetails.getAuthorities());
    }
}

