/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config.annotation.web.configuration;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.aop.framework.Advised;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.security.authentication.AnonymousAuthenticationProvider;
import org.springframework.security.authentication.AuthenticationEventPublisher;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerEndpointsConfiguration;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.endpoint.FrameworkEndpointHandlerMapping;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.ReflectionUtils;

@Configuration
public class ResourceServerConfiguration
extends WebSecurityConfigurerAdapter
implements Ordered {
    private int order = 3;
    @Autowired(required=false)
    private TokenStore tokenStore;
    @Autowired(required=false)
    private AuthenticationEventPublisher eventPublisher;
    @Autowired(required=false)
    private Map<String, ResourceServerTokenServices> tokenServices;
    @Autowired
    private ApplicationContext context;
    private List<ResourceServerConfigurer> configurers = Collections.emptyList();
    @Autowired(required=false)
    private AuthorizationServerEndpointsConfiguration endpoints;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Autowired(required=false)
    public void setConfigurers(List<ResourceServerConfigurer> configurers) {
        this.configurers = configurers;
    }

    @Autowired
    protected void init(AuthenticationManagerBuilder builder) {
        if (!builder.isConfigured()) {
            builder.authenticationProvider((AuthenticationProvider)new AnonymousAuthenticationProvider("default"));
        }
    }

    protected void configure(HttpSecurity http) throws Exception {
        ResourceServerSecurityConfigurer resources = new ResourceServerSecurityConfigurer();
        ResourceServerTokenServices services = this.resolveTokenServices();
        if (services != null) {
            resources.tokenServices(services);
        } else if (this.tokenStore != null) {
            resources.tokenStore(this.tokenStore);
        } else if (this.endpoints != null) {
            resources.tokenStore(this.endpoints.getEndpointsConfigurer().getTokenStore());
        }
        if (this.eventPublisher != null) {
            resources.eventPublisher(this.eventPublisher);
        }
        for (ResourceServerConfigurer configurer : this.configurers) {
            configurer.configure(resources);
        }
        ((HttpSecurity)((HttpSecurity)http.exceptionHandling().accessDeniedHandler(resources.getAccessDeniedHandler()).and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).csrf().disable();
        http.apply((SecurityConfigurerAdapter)resources);
        HttpSecurity.RequestMatcherConfigurer requests = http.requestMatchers();
        if (this.endpoints != null) {
            requests.requestMatchers(new RequestMatcher[]{new NotOAuthRequestMatcher(this.endpoints.oauth2EndpointHandlerMapping())});
        }
        for (ResourceServerConfigurer configurer : this.configurers) {
            configurer.configure(http);
        }
        if (this.configurers.isEmpty()) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).authenticated();
        }
    }

    private ResourceServerTokenServices resolveTokenServices() {
        ResourceServerTokenServices two;
        Iterator<ResourceServerTokenServices> iter;
        ResourceServerTokenServices one;
        if (this.tokenServices == null || this.tokenServices.size() == 0) {
            return null;
        }
        if (this.tokenServices.size() == 1) {
            return this.tokenServices.values().iterator().next();
        }
        if (this.tokenServices.size() == 2 && this.elementsEqual(one = (iter = this.tokenServices.values().iterator()).next(), two = iter.next())) {
            return one;
        }
        return (ResourceServerTokenServices)this.context.getBean(ResourceServerTokenServices.class);
    }

    private boolean elementsEqual(Object one, Object two) {
        Object targetTwo;
        if (one == two) {
            return true;
        }
        Object targetOne = this.findTarget(one);
        return targetOne == (targetTwo = this.findTarget(two));
    }

    private Object findTarget(Object item) {
        Object current = item;
        while (current instanceof Advised) {
            try {
                current = ((Advised)current).getTargetSource().getTarget();
            }
            catch (Exception e) {
                ReflectionUtils.rethrowRuntimeException((Throwable)e);
            }
        }
        return current;
    }

    private static class NotOAuthRequestMatcher
    implements RequestMatcher {
        private FrameworkEndpointHandlerMapping mapping;

        public NotOAuthRequestMatcher(FrameworkEndpointHandlerMapping mapping) {
            this.mapping = mapping;
        }

        public boolean matches(HttpServletRequest request) {
            String requestPath = this.getRequestPath(request);
            for (String path : this.mapping.getPaths()) {
                if (!requestPath.startsWith(path)) continue;
                return false;
            }
            return true;
        }

        private String getRequestPath(HttpServletRequest request) {
            String url = request.getServletPath();
            if (request.getPathInfo() != null) {
                url = String.valueOf(url) + request.getPathInfo();
            }
            return url;
        }
    }
}

