/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.common.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.security.oauth2.common.util.DefaultSerializationStrategy;
import org.springframework.util.ClassUtils;

@Deprecated
public class WhitelistedSerializationStrategy
extends DefaultSerializationStrategy {
    private static final List<String> DEFAULT_ALLOWED_CLASSES;
    private final List<String> allowedClasses;

    public WhitelistedSerializationStrategy() {
        this(DEFAULT_ALLOWED_CLASSES);
    }

    public WhitelistedSerializationStrategy(List<String> allowedClasses) {
        this.allowedClasses = Collections.unmodifiableList(allowedClasses);
    }

    @Override
    protected ObjectInputStream createObjectInputStream(byte[] byteArray) throws IOException {
        return new WhitelistedObjectInputStream(new ByteArrayInputStream(byteArray), Thread.currentThread().getContextClassLoader(), this.allowedClasses);
    }

    static {
        ArrayList<String> classes = new ArrayList<String>();
        classes.add("java.lang.");
        classes.add("java.util.");
        classes.add("org.springframework.security.");
        DEFAULT_ALLOWED_CLASSES = Collections.unmodifiableList(classes);
    }

    private static class WhitelistedObjectInputStream
    extends ObjectInputStream {
        private final List<String> allowedClasses;
        private final ClassLoader classLoader;

        private WhitelistedObjectInputStream(InputStream in, ClassLoader classLoader, List<String> allowedClasses) throws IOException {
            super(in);
            this.classLoader = classLoader;
            this.allowedClasses = Collections.unmodifiableList(allowedClasses);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
            if (this.isProhibited(classDesc.getName())) {
                throw new NotSerializableException("Not allowed to deserialize " + classDesc.getName());
            }
            if (this.classLoader != null) {
                return ClassUtils.forName((String)classDesc.getName(), (ClassLoader)this.classLoader);
            }
            return super.resolveClass(classDesc);
        }

        private boolean isProhibited(String className) {
            for (String allowedClass : this.allowedClasses) {
                if (!className.startsWith(allowedClass)) continue;
                return false;
            }
            return true;
        }
    }
}

