/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.RegexRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MatcherType {
    ant(AntPathRequestMatcher.class),
    regex(RegexRequestMatcher.class),
    ciRegex(RegexRequestMatcher.class);

    private static final String ATT_MATCHER_TYPE = "request-matcher";
    private final Class<? extends RequestMatcher> type;

    private MatcherType(Class<? extends RequestMatcher> type) {
        this.type = type;
    }

    public BeanDefinition createMatcher(String path, String method) {
        if (("/**".equals(path) || "**".equals(path)) && method == null) {
            return new RootBeanDefinition(AnyRequestMatcher.class);
        }
        BeanDefinitionBuilder matcherBldr = BeanDefinitionBuilder.rootBeanDefinition(this.type);
        matcherBldr.addConstructorArgValue((Object)path);
        matcherBldr.addConstructorArgValue((Object)method);
        if (this == ciRegex) {
            matcherBldr.addConstructorArgValue((Object)true);
        }
        return matcherBldr.getBeanDefinition();
    }

    static MatcherType fromElement(Element elt) {
        if (StringUtils.hasText((String)elt.getAttribute(ATT_MATCHER_TYPE))) {
            return MatcherType.valueOf(elt.getAttribute(ATT_MATCHER_TYPE));
        }
        return ant;
    }
}

