/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.method;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.config.AopNamespaceUtils;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.aop.target.LazyInitTargetSource;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.annotation.Jsr250MethodSecurityMetadataSource;
import org.springframework.security.access.annotation.Jsr250Voter;
import org.springframework.security.access.annotation.SecuredAnnotationSecurityMetadataSource;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.ExpressionBasedAnnotationAttributeFactory;
import org.springframework.security.access.expression.method.ExpressionBasedPostInvocationAdvice;
import org.springframework.security.access.expression.method.ExpressionBasedPreInvocationAdvice;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.access.intercept.AfterInvocationProviderManager;
import org.springframework.security.access.intercept.aopalliance.MethodSecurityInterceptor;
import org.springframework.security.access.intercept.aopalliance.MethodSecurityMetadataSourceAdvisor;
import org.springframework.security.access.intercept.aspectj.AspectJMethodSecurityInterceptor;
import org.springframework.security.access.method.DelegatingMethodSecurityMetadataSource;
import org.springframework.security.access.method.MapBasedMethodSecurityMetadataSource;
import org.springframework.security.access.prepost.PostInvocationAdviceProvider;
import org.springframework.security.access.prepost.PreInvocationAuthorizationAdviceVoter;
import org.springframework.security.access.prepost.PrePostAnnotationSecurityMetadataSource;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.access.vote.AuthenticatedVoter;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.core.GrantedAuthorityDefaults;
import org.springframework.security.config.method.ProtectPointcutPostProcessor;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class GlobalMethodSecurityBeanDefinitionParser
implements BeanDefinitionParser {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final String ATT_AUTHENTICATION_MANAGER_REF = "authentication-manager-ref";
    private static final String ATT_ACCESS = "access";
    private static final String ATT_EXPRESSION = "expression";
    private static final String ATT_ACCESS_MGR = "access-decision-manager-ref";
    private static final String ATT_RUN_AS_MGR = "run-as-manager-ref";
    private static final String ATT_USE_JSR250 = "jsr250-annotations";
    private static final String ATT_USE_SECURED = "secured-annotations";
    private static final String ATT_USE_PREPOST = "pre-post-annotations";
    private static final String ATT_REF = "ref";
    private static final String ATT_MODE = "mode";
    private static final String ATT_ADVICE_ORDER = "order";
    private static final String ATT_META_DATA_SOURCE_REF = "metadata-source-ref";

    public BeanDefinition parse(Element element, ParserContext pc) {
        Map<String, List<ConfigAttribute>> pointcutMap;
        CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), pc.extractSource((Object)element));
        pc.pushContainingComponent(compositeDef);
        Object source = pc.extractSource((Object)element);
        ManagedList delegates = new ManagedList();
        boolean jsr250Enabled = "enabled".equals(element.getAttribute(ATT_USE_JSR250));
        boolean useSecured = "enabled".equals(element.getAttribute(ATT_USE_SECURED));
        boolean prePostAnnotationsEnabled = "enabled".equals(element.getAttribute(ATT_USE_PREPOST));
        boolean useAspectJ = "aspectj".equals(element.getAttribute(ATT_MODE));
        AbstractBeanDefinition preInvocationVoter = null;
        ManagedList afterInvocationProviders = new ManagedList();
        String metaDataSourceId = element.getAttribute(ATT_META_DATA_SOURCE_REF);
        if (StringUtils.hasText((String)metaDataSourceId)) {
            delegates.add((Object)new RuntimeBeanReference(metaDataSourceId));
        }
        if (prePostAnnotationsEnabled) {
            Element prePostElt = DomUtils.getChildElementByTagName((Element)element, (String)"pre-post-annotation-handling");
            Element expressionHandlerElt = DomUtils.getChildElementByTagName((Element)element, (String)"expression-handler");
            if (prePostElt != null && expressionHandlerElt != null) {
                pc.getReaderContext().error("pre-post-annotation-handling and expression-handler cannot be used together ", source);
            }
            BeanDefinitionBuilder preInvocationVoterBldr = BeanDefinitionBuilder.rootBeanDefinition(PreInvocationAuthorizationAdviceVoter.class);
            BeanDefinitionBuilder afterInvocationBldr = BeanDefinitionBuilder.rootBeanDefinition(PostInvocationAdviceProvider.class);
            BeanDefinitionBuilder mds = BeanDefinitionBuilder.rootBeanDefinition(PrePostAnnotationSecurityMetadataSource.class);
            if (prePostElt != null) {
                String attributeFactoryRef = DomUtils.getChildElementByTagName((Element)prePostElt, (String)"invocation-attribute-factory").getAttribute(ATT_REF);
                String preAdviceRef = DomUtils.getChildElementByTagName((Element)prePostElt, (String)"pre-invocation-advice").getAttribute(ATT_REF);
                String postAdviceRef = DomUtils.getChildElementByTagName((Element)prePostElt, (String)"post-invocation-advice").getAttribute(ATT_REF);
                mds.addConstructorArgReference(attributeFactoryRef);
                preInvocationVoterBldr.addConstructorArgReference(preAdviceRef);
                afterInvocationBldr.addConstructorArgReference(postAdviceRef);
            } else {
                String expressionHandlerRef;
                String string = expressionHandlerRef = expressionHandlerElt == null ? null : expressionHandlerElt.getAttribute(ATT_REF);
                if (StringUtils.hasText((String)expressionHandlerRef)) {
                    this.logger.info((Object)("Using bean '" + expressionHandlerRef + "' as method ExpressionHandler implementation"));
                    RootBeanDefinition lazyInitPP = new RootBeanDefinition(LazyInitBeanDefinitionRegistryPostProcessor.class);
                    lazyInitPP.getConstructorArgumentValues().addGenericArgumentValue((Object)expressionHandlerRef);
                    pc.getReaderContext().registerWithGeneratedName((BeanDefinition)lazyInitPP);
                    BeanDefinitionBuilder lazyMethodSecurityExpressionHandlerBldr = BeanDefinitionBuilder.rootBeanDefinition(LazyInitTargetSource.class);
                    lazyMethodSecurityExpressionHandlerBldr.addPropertyValue("targetBeanName", (Object)expressionHandlerRef);
                    BeanDefinitionBuilder expressionHandlerProxyBldr = BeanDefinitionBuilder.rootBeanDefinition(ProxyFactoryBean.class);
                    expressionHandlerProxyBldr.addPropertyValue("targetSource", (Object)lazyMethodSecurityExpressionHandlerBldr.getBeanDefinition());
                    expressionHandlerProxyBldr.addPropertyValue("proxyInterfaces", MethodSecurityExpressionHandler.class);
                    expressionHandlerRef = pc.getReaderContext().generateBeanName((BeanDefinition)expressionHandlerProxyBldr.getBeanDefinition());
                    pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)expressionHandlerProxyBldr.getBeanDefinition(), expressionHandlerRef));
                } else {
                    RootBeanDefinition expressionHandler = this.registerWithDefaultRolePrefix(pc, DefaultMethodSecurityExpressionHandlerBeanFactory.class);
                    expressionHandlerRef = pc.getReaderContext().generateBeanName((BeanDefinition)expressionHandler);
                    pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)expressionHandler, expressionHandlerRef));
                    this.logger.info((Object)"Expressions were enabled for method security but no SecurityExpressionHandler was configured. All hasPermision() expressions will evaluate to false.");
                }
                BeanDefinitionBuilder expressionPreAdviceBldr = BeanDefinitionBuilder.rootBeanDefinition(ExpressionBasedPreInvocationAdvice.class);
                expressionPreAdviceBldr.addPropertyReference("expressionHandler", expressionHandlerRef);
                preInvocationVoterBldr.addConstructorArgValue((Object)expressionPreAdviceBldr.getBeanDefinition());
                BeanDefinitionBuilder expressionPostAdviceBldr = BeanDefinitionBuilder.rootBeanDefinition(ExpressionBasedPostInvocationAdvice.class);
                expressionPostAdviceBldr.addConstructorArgReference(expressionHandlerRef);
                afterInvocationBldr.addConstructorArgValue((Object)expressionPostAdviceBldr.getBeanDefinition());
                BeanDefinitionBuilder annotationInvocationFactory = BeanDefinitionBuilder.rootBeanDefinition(ExpressionBasedAnnotationAttributeFactory.class);
                annotationInvocationFactory.addConstructorArgReference(expressionHandlerRef);
                mds.addConstructorArgValue((Object)annotationInvocationFactory.getBeanDefinition());
            }
            preInvocationVoter = preInvocationVoterBldr.getBeanDefinition();
            afterInvocationProviders.add((Object)afterInvocationBldr.getBeanDefinition());
            delegates.add((Object)mds.getBeanDefinition());
        }
        if (useSecured) {
            delegates.add((Object)BeanDefinitionBuilder.rootBeanDefinition(SecuredAnnotationSecurityMetadataSource.class).getBeanDefinition());
        }
        if (jsr250Enabled) {
            RootBeanDefinition jsrMetadataSource = this.registerWithDefaultRolePrefix(pc, Jsr250MethodSecurityMetadataSourceBeanFactory.class);
            delegates.add((Object)jsrMetadataSource);
        }
        if ((pointcutMap = this.parseProtectPointcuts(pc, DomUtils.getChildElementsByTagName((Element)element, (String)"protect-pointcut"))).size() > 0) {
            if (useAspectJ) {
                pc.getReaderContext().error("You can't use AspectJ mode with protect-pointcut definitions", source);
            }
            RootBeanDefinition mapBasedMetadataSource = new RootBeanDefinition(MapBasedMethodSecurityMetadataSource.class);
            RuntimeBeanReference ref = new RuntimeBeanReference(pc.getReaderContext().generateBeanName((BeanDefinition)mapBasedMetadataSource));
            delegates.add((Object)ref);
            pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)mapBasedMetadataSource, ref.getBeanName()));
            this.registerProtectPointcutPostProcessor(pc, pointcutMap, (BeanReference)ref, source);
        }
        BeanReference metadataSource = this.registerDelegatingMethodSecurityMetadataSource(pc, delegates, source);
        List afterInvocationElts = DomUtils.getChildElementsByTagName((Element)element, (String)"after-invocation-provider");
        for (Element elt : afterInvocationElts) {
            afterInvocationProviders.add((Object)new RuntimeBeanReference(elt.getAttribute(ATT_REF)));
        }
        String accessManagerId = element.getAttribute(ATT_ACCESS_MGR);
        if (!StringUtils.hasText((String)accessManagerId)) {
            accessManagerId = this.registerAccessManager(pc, jsr250Enabled, (BeanDefinition)preInvocationVoter);
        }
        String authMgrRef = element.getAttribute(ATT_AUTHENTICATION_MANAGER_REF);
        String runAsManagerId = element.getAttribute(ATT_RUN_AS_MGR);
        BeanReference interceptor = this.registerMethodSecurityInterceptor(pc, authMgrRef, accessManagerId, runAsManagerId, metadataSource, (List<BeanMetadataElement>)afterInvocationProviders, source, useAspectJ);
        if (useAspectJ) {
            BeanDefinitionBuilder aspect = BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.security.access.intercept.aspectj.aspect.AnnotationSecurityAspect");
            aspect.setFactoryMethod("aspectOf");
            aspect.setRole(2);
            aspect.addPropertyValue("securityInterceptor", (Object)interceptor);
            String id = pc.getReaderContext().registerWithGeneratedName((BeanDefinition)aspect.getBeanDefinition());
            pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)aspect.getBeanDefinition(), id));
        } else {
            this.registerAdvisor(pc, interceptor, metadataSource, source, element.getAttribute(ATT_ADVICE_ORDER));
            AopNamespaceUtils.registerAutoProxyCreatorIfNecessary((ParserContext)pc, (Element)element);
        }
        pc.popAndRegisterContainingComponent();
        return null;
    }

    private String registerAccessManager(ParserContext pc, boolean jsr250Enabled, BeanDefinition expressionVoter) {
        BeanDefinitionBuilder accessMgrBuilder = BeanDefinitionBuilder.rootBeanDefinition(AffirmativeBased.class);
        ManagedList voters = new ManagedList(4);
        if (expressionVoter != null) {
            voters.add((Object)expressionVoter);
        }
        voters.add((Object)new RootBeanDefinition(RoleVoter.class));
        voters.add((Object)new RootBeanDefinition(AuthenticatedVoter.class));
        if (jsr250Enabled) {
            voters.add((Object)new RootBeanDefinition(Jsr250Voter.class));
        }
        accessMgrBuilder.addConstructorArgValue((Object)voters);
        AbstractBeanDefinition accessManager = accessMgrBuilder.getBeanDefinition();
        String id = pc.getReaderContext().generateBeanName((BeanDefinition)accessManager);
        pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)accessManager, id));
        return id;
    }

    private BeanReference registerDelegatingMethodSecurityMetadataSource(ParserContext pc, ManagedList delegates, Object source) {
        RootBeanDefinition delegatingMethodSecurityMetadataSource = new RootBeanDefinition(DelegatingMethodSecurityMetadataSource.class);
        delegatingMethodSecurityMetadataSource.setSource(source);
        delegatingMethodSecurityMetadataSource.getConstructorArgumentValues().addGenericArgumentValue((Object)delegates);
        String id = pc.getReaderContext().generateBeanName((BeanDefinition)delegatingMethodSecurityMetadataSource);
        pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)delegatingMethodSecurityMetadataSource, id));
        return new RuntimeBeanReference(id);
    }

    private void registerProtectPointcutPostProcessor(ParserContext parserContext, Map<String, List<ConfigAttribute>> pointcutMap, BeanReference mapBasedMethodSecurityMetadataSource, Object source) {
        RootBeanDefinition ppbp = new RootBeanDefinition(ProtectPointcutPostProcessor.class);
        ppbp.setRole(2);
        ppbp.setSource(source);
        ppbp.getConstructorArgumentValues().addGenericArgumentValue((Object)mapBasedMethodSecurityMetadataSource);
        ppbp.getPropertyValues().addPropertyValue("pointcutMap", pointcutMap);
        parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)ppbp);
    }

    private Map<String, List<ConfigAttribute>> parseProtectPointcuts(ParserContext parserContext, List<Element> protectPointcutElts) {
        LinkedHashMap<String, List<ConfigAttribute>> pointcutMap = new LinkedHashMap<String, List<ConfigAttribute>>();
        for (Element childElt : protectPointcutElts) {
            String accessConfig = childElt.getAttribute(ATT_ACCESS);
            String expression = childElt.getAttribute(ATT_EXPRESSION);
            if (!StringUtils.hasText((String)accessConfig)) {
                parserContext.getReaderContext().error("Access configuration required", parserContext.extractSource((Object)childElt));
            }
            if (!StringUtils.hasText((String)expression)) {
                parserContext.getReaderContext().error("Pointcut expression required", parserContext.extractSource((Object)childElt));
            }
            String[] attributeTokens = StringUtils.commaDelimitedListToStringArray((String)accessConfig);
            ArrayList<SecurityConfig> attributes = new ArrayList<SecurityConfig>(attributeTokens.length);
            for (String token : attributeTokens) {
                attributes.add(new SecurityConfig(token));
            }
            pointcutMap.put(expression, attributes);
        }
        return pointcutMap;
    }

    private BeanReference registerMethodSecurityInterceptor(ParserContext pc, String authMgrRef, String accessManagerId, String runAsManagerId, BeanReference metadataSource, List<BeanMetadataElement> afterInvocationProviders, Object source, boolean useAspectJ) {
        BeanDefinitionBuilder bldr = BeanDefinitionBuilder.rootBeanDefinition(useAspectJ ? AspectJMethodSecurityInterceptor.class : MethodSecurityInterceptor.class);
        bldr.getRawBeanDefinition().setSource(source);
        bldr.addPropertyReference("accessDecisionManager", accessManagerId);
        RootBeanDefinition authMgr = new RootBeanDefinition(AuthenticationManagerDelegator.class);
        authMgr.getConstructorArgumentValues().addGenericArgumentValue((Object)authMgrRef);
        bldr.addPropertyValue("authenticationManager", (Object)authMgr);
        bldr.addPropertyValue("securityMetadataSource", (Object)metadataSource);
        if (StringUtils.hasText((String)runAsManagerId)) {
            bldr.addPropertyReference("runAsManager", runAsManagerId);
        }
        if (!afterInvocationProviders.isEmpty()) {
            RootBeanDefinition afterInvocationManager = new RootBeanDefinition(AfterInvocationProviderManager.class);
            afterInvocationManager.getPropertyValues().addPropertyValue("providers", afterInvocationProviders);
            bldr.addPropertyValue("afterInvocationManager", (Object)afterInvocationManager);
        }
        AbstractBeanDefinition bean = bldr.getBeanDefinition();
        String id = pc.getReaderContext().generateBeanName((BeanDefinition)bean);
        pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)bean, id));
        return new RuntimeBeanReference(id);
    }

    private void registerAdvisor(ParserContext parserContext, BeanReference interceptor, BeanReference metadataSource, Object source, String adviceOrder) {
        if (parserContext.getRegistry().containsBeanDefinition("org.springframework.security.methodSecurityMetadataSourceAdvisor")) {
            parserContext.getReaderContext().error("Duplicate <global-method-security> detected.", source);
        }
        RootBeanDefinition advisor = new RootBeanDefinition(MethodSecurityMetadataSourceAdvisor.class);
        if (StringUtils.hasText((String)adviceOrder)) {
            advisor.getPropertyValues().addPropertyValue(ATT_ADVICE_ORDER, (Object)adviceOrder);
        }
        advisor.setRole(2);
        advisor.setSource(source);
        advisor.getConstructorArgumentValues().addGenericArgumentValue((Object)interceptor.getBeanName());
        advisor.getConstructorArgumentValues().addGenericArgumentValue((Object)metadataSource);
        advisor.getConstructorArgumentValues().addGenericArgumentValue((Object)metadataSource.getBeanName());
        parserContext.getRegistry().registerBeanDefinition("org.springframework.security.methodSecurityMetadataSourceAdvisor", (BeanDefinition)advisor);
    }

    private RootBeanDefinition registerWithDefaultRolePrefix(ParserContext pc, Class<? extends AbstractGrantedAuthorityDefaultsBeanFactory> beanFactoryClass) {
        RootBeanDefinition beanFactoryDefinition = new RootBeanDefinition(beanFactoryClass);
        String beanFactoryRef = pc.getReaderContext().generateBeanName((BeanDefinition)beanFactoryDefinition);
        pc.getRegistry().registerBeanDefinition(beanFactoryRef, (BeanDefinition)beanFactoryDefinition);
        RootBeanDefinition bean = new RootBeanDefinition();
        bean.setFactoryBeanName(beanFactoryRef);
        bean.setFactoryMethodName("getBean");
        return bean;
    }

    private static final class LazyInitBeanDefinitionRegistryPostProcessor
    implements BeanDefinitionRegistryPostProcessor {
        private final String beanName;

        private LazyInitBeanDefinitionRegistryPostProcessor(String beanName) {
            this.beanName = beanName;
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            if (!registry.containsBeanDefinition(this.beanName)) {
                return;
            }
            BeanDefinition beanDefinition = registry.getBeanDefinition(this.beanName);
            beanDefinition.setLazyInit(true);
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }
    }

    static abstract class AbstractGrantedAuthorityDefaultsBeanFactory
    implements ApplicationContextAware {
        protected String rolePrefix = "ROLE_";

        AbstractGrantedAuthorityDefaultsBeanFactory() {
        }

        public final void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            String[] grantedAuthorityDefaultsBeanNames = applicationContext.getBeanNamesForType(GrantedAuthorityDefaults.class);
            if (grantedAuthorityDefaultsBeanNames.length == 1) {
                GrantedAuthorityDefaults grantedAuthorityDefaults = (GrantedAuthorityDefaults)applicationContext.getBean(grantedAuthorityDefaultsBeanNames[0], GrantedAuthorityDefaults.class);
                this.rolePrefix = grantedAuthorityDefaults.getRolePrefix();
            }
        }
    }

    static class DefaultMethodSecurityExpressionHandlerBeanFactory
    extends AbstractGrantedAuthorityDefaultsBeanFactory {
        private DefaultMethodSecurityExpressionHandler handler = new DefaultMethodSecurityExpressionHandler();

        DefaultMethodSecurityExpressionHandlerBeanFactory() {
        }

        public DefaultMethodSecurityExpressionHandler getBean() {
            this.handler.setDefaultRolePrefix(this.rolePrefix);
            return this.handler;
        }
    }

    static class Jsr250MethodSecurityMetadataSourceBeanFactory
    extends AbstractGrantedAuthorityDefaultsBeanFactory {
        private Jsr250MethodSecurityMetadataSource source = new Jsr250MethodSecurityMetadataSource();

        Jsr250MethodSecurityMetadataSourceBeanFactory() {
        }

        public Jsr250MethodSecurityMetadataSource getBean() {
            this.source.setDefaultRolePrefix(this.rolePrefix);
            return this.source;
        }
    }

    static final class AuthenticationManagerDelegator
    implements AuthenticationManager,
    BeanFactoryAware {
        private AuthenticationManager delegate;
        private final Object delegateMonitor = new Object();
        private BeanFactory beanFactory;
        private final String authMgrBean;

        AuthenticationManagerDelegator(String authMgrBean) {
            this.authMgrBean = StringUtils.hasText((String)authMgrBean) ? authMgrBean : "org.springframework.security.authenticationManager";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Authentication authenticate(Authentication authentication) throws AuthenticationException {
            Object object = this.delegateMonitor;
            synchronized (object) {
                if (this.delegate == null) {
                    Assert.state((this.beanFactory != null ? 1 : 0) != 0, () -> "BeanFactory must be set to resolve " + this.authMgrBean);
                    try {
                        this.delegate = (AuthenticationManager)this.beanFactory.getBean(this.authMgrBean, AuthenticationManager.class);
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        if ("org.springframework.security.authenticationManager".equals(e.getBeanName())) {
                            throw new NoSuchBeanDefinitionException("org.springframework.security.authenticationManager", "Did you forget to add a global <authentication-manager> element to your configuration (with child <authentication-provider> elements)? Alternatively you can use the authentication-manager-ref attribute on your <http> and <global-method-security> elements.");
                        }
                        throw e;
                    }
                }
            }
            return this.delegate.authenticate(authentication);
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }
    }
}

