/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.oauth2.client;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.oauth2.client.CommonOAuth2Provider;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrations;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthenticationMethod;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public final class ClientRegistrationsBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String ELT_CLIENT_REGISTRATION = "client-registration";
    private static final String ELT_PROVIDER = "provider";
    private static final String ATT_REGISTRATION_ID = "registration-id";
    private static final String ATT_CLIENT_ID = "client-id";
    private static final String ATT_CLIENT_SECRET = "client-secret";
    private static final String ATT_CLIENT_AUTHENTICATION_METHOD = "client-authentication-method";
    private static final String ATT_AUTHORIZATION_GRANT_TYPE = "authorization-grant-type";
    private static final String ATT_REDIRECT_URI = "redirect-uri";
    private static final String ATT_SCOPE = "scope";
    private static final String ATT_CLIENT_NAME = "client-name";
    private static final String ATT_PROVIDER_ID = "provider-id";
    private static final String ATT_AUTHORIZATION_URI = "authorization-uri";
    private static final String ATT_TOKEN_URI = "token-uri";
    private static final String ATT_USER_INFO_URI = "user-info-uri";
    private static final String ATT_USER_INFO_AUTHENTICATION_METHOD = "user-info-authentication-method";
    private static final String ATT_USER_INFO_USER_NAME_ATTRIBUTE = "user-info-user-name-attribute";
    private static final String ATT_JWK_SET_URI = "jwk-set-uri";
    private static final String ATT_ISSUER_URI = "issuer-uri";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), parserContext.extractSource((Object)element));
        parserContext.pushContainingComponent(compositeDef);
        Map<String, Map<String, String>> providers = this.getProviders(element);
        List<ClientRegistration> clientRegistrations = this.getClientRegistrations(element, parserContext, providers);
        AbstractBeanDefinition clientRegistrationRepositoryBean = BeanDefinitionBuilder.rootBeanDefinition(InMemoryClientRegistrationRepository.class).addConstructorArgValue(clientRegistrations).getBeanDefinition();
        String clientRegistrationRepositoryId = parserContext.getReaderContext().generateBeanName((BeanDefinition)clientRegistrationRepositoryBean);
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)clientRegistrationRepositoryBean, clientRegistrationRepositoryId));
        parserContext.popAndRegisterContainingComponent();
        return null;
    }

    private List<ClientRegistration> getClientRegistrations(Element element, ParserContext parserContext, Map<String, Map<String, String>> providers) {
        List clientRegistrationElts = DomUtils.getChildElementsByTagName((Element)element, (String)ELT_CLIENT_REGISTRATION);
        ArrayList<ClientRegistration> clientRegistrations = new ArrayList<ClientRegistration>();
        for (Element clientRegistrationElt : clientRegistrationElts) {
            String providerId;
            String registrationId = clientRegistrationElt.getAttribute(ATT_REGISTRATION_ID);
            ClientRegistration.Builder builder = ClientRegistrationsBeanDefinitionParser.getBuilderFromIssuerIfPossible(registrationId, providerId = clientRegistrationElt.getAttribute(ATT_PROVIDER_ID), providers);
            if (builder == null && (builder = ClientRegistrationsBeanDefinitionParser.getBuilder(registrationId, providerId, providers)) == null) {
                Object source = parserContext.extractSource((Object)element);
                parserContext.getReaderContext().error(ClientRegistrationsBeanDefinitionParser.getErrorMessage(providerId, registrationId), source);
                continue;
            }
            ClientRegistrationsBeanDefinitionParser.getOptionalIfNotEmpty(clientRegistrationElt.getAttribute(ATT_CLIENT_ID)).ifPresent(arg_0 -> ((ClientRegistration.Builder)builder).clientId(arg_0));
            ClientRegistrationsBeanDefinitionParser.getOptionalIfNotEmpty(clientRegistrationElt.getAttribute(ATT_CLIENT_SECRET)).ifPresent(arg_0 -> ((ClientRegistration.Builder)builder).clientSecret(arg_0));
            ClientRegistrationsBeanDefinitionParser.getOptionalIfNotEmpty(clientRegistrationElt.getAttribute(ATT_CLIENT_AUTHENTICATION_METHOD)).map(ClientAuthenticationMethod::new).ifPresent(arg_0 -> ((ClientRegistration.Builder)builder).clientAuthenticationMethod(arg_0));
            ClientRegistrationsBeanDefinitionParser.getOptionalIfNotEmpty(clientRegistrationElt.getAttribute(ATT_AUTHORIZATION_GRANT_TYPE)).map(AuthorizationGrantType::new).ifPresent(arg_0 -> ((ClientRegistration.Builder)builder).authorizationGrantType(arg_0));
            ClientRegistrationsBeanDefinitionParser.getOptionalIfNotEmpty(clientRegistrationElt.getAttribute(ATT_REDIRECT_URI)).ifPresent(arg_0 -> ((ClientRegistration.Builder)builder).redirectUriTemplate(arg_0));
            ClientRegistrationsBeanDefinitionParser.getOptionalIfNotEmpty(clientRegistrationElt.getAttribute(ATT_SCOPE)).map(StringUtils::commaDelimitedListToSet).ifPresent(arg_0 -> ((ClientRegistration.Builder)builder).scope(arg_0));
            ClientRegistrationsBeanDefinitionParser.getOptionalIfNotEmpty(clientRegistrationElt.getAttribute(ATT_CLIENT_NAME)).ifPresent(arg_0 -> ((ClientRegistration.Builder)builder).clientName(arg_0));
            clientRegistrations.add(builder.build());
        }
        return clientRegistrations;
    }

    private Map<String, Map<String, String>> getProviders(Element element) {
        List providerElts = DomUtils.getChildElementsByTagName((Element)element, (String)ELT_PROVIDER);
        HashMap<String, Map<String, String>> providers = new HashMap<String, Map<String, String>>();
        for (Element providerElt : providerElts) {
            HashMap<String, String> provider = new HashMap<String, String>();
            String providerId = providerElt.getAttribute(ATT_PROVIDER_ID);
            provider.put(ATT_PROVIDER_ID, providerId);
            ClientRegistrationsBeanDefinitionParser.getOptionalIfNotEmpty(providerElt.getAttribute(ATT_AUTHORIZATION_URI)).ifPresent(value -> provider.put(ATT_AUTHORIZATION_URI, (String)value));
            ClientRegistrationsBeanDefinitionParser.getOptionalIfNotEmpty(providerElt.getAttribute(ATT_TOKEN_URI)).ifPresent(value -> provider.put(ATT_TOKEN_URI, (String)value));
            ClientRegistrationsBeanDefinitionParser.getOptionalIfNotEmpty(providerElt.getAttribute(ATT_USER_INFO_URI)).ifPresent(value -> provider.put(ATT_USER_INFO_URI, (String)value));
            ClientRegistrationsBeanDefinitionParser.getOptionalIfNotEmpty(providerElt.getAttribute(ATT_USER_INFO_AUTHENTICATION_METHOD)).ifPresent(value -> provider.put(ATT_USER_INFO_AUTHENTICATION_METHOD, (String)value));
            ClientRegistrationsBeanDefinitionParser.getOptionalIfNotEmpty(providerElt.getAttribute(ATT_USER_INFO_USER_NAME_ATTRIBUTE)).ifPresent(value -> provider.put(ATT_USER_INFO_USER_NAME_ATTRIBUTE, (String)value));
            ClientRegistrationsBeanDefinitionParser.getOptionalIfNotEmpty(providerElt.getAttribute(ATT_JWK_SET_URI)).ifPresent(value -> provider.put(ATT_JWK_SET_URI, (String)value));
            ClientRegistrationsBeanDefinitionParser.getOptionalIfNotEmpty(providerElt.getAttribute(ATT_ISSUER_URI)).ifPresent(value -> provider.put(ATT_ISSUER_URI, (String)value));
            providers.put(providerId, provider);
        }
        return providers;
    }

    private static ClientRegistration.Builder getBuilderFromIssuerIfPossible(String registrationId, String configuredProviderId, Map<String, Map<String, String>> providers) {
        Map<String, String> provider;
        String issuer;
        String providerId;
        String string = providerId = configuredProviderId != null ? configuredProviderId : registrationId;
        if (providers.containsKey(providerId) && !StringUtils.isEmpty((Object)(issuer = (provider = providers.get(providerId)).get(ATT_ISSUER_URI)))) {
            ClientRegistration.Builder builder = ClientRegistrations.fromIssuerLocation((String)issuer).registrationId(registrationId);
            return ClientRegistrationsBeanDefinitionParser.getBuilder(builder, provider);
        }
        return null;
    }

    private static ClientRegistration.Builder getBuilder(String registrationId, String configuredProviderId, Map<String, Map<String, String>> providers) {
        ClientRegistration.Builder builder;
        String providerId = configuredProviderId != null ? configuredProviderId : registrationId;
        CommonOAuth2Provider provider = ClientRegistrationsBeanDefinitionParser.getCommonProvider(providerId);
        if (provider == null && !providers.containsKey(providerId)) {
            return null;
        }
        ClientRegistration.Builder builder2 = builder = provider != null ? provider.getBuilder(registrationId) : ClientRegistration.withRegistrationId((String)registrationId);
        if (providers.containsKey(providerId)) {
            return ClientRegistrationsBeanDefinitionParser.getBuilder(builder, providers.get(providerId));
        }
        return builder;
    }

    private static ClientRegistration.Builder getBuilder(ClientRegistration.Builder builder, Map<String, String> provider) {
        ClientRegistrationsBeanDefinitionParser.getOptionalIfNotEmpty(provider.get(ATT_AUTHORIZATION_URI)).ifPresent(arg_0 -> ((ClientRegistration.Builder)builder).authorizationUri(arg_0));
        ClientRegistrationsBeanDefinitionParser.getOptionalIfNotEmpty(provider.get(ATT_TOKEN_URI)).ifPresent(arg_0 -> ((ClientRegistration.Builder)builder).tokenUri(arg_0));
        ClientRegistrationsBeanDefinitionParser.getOptionalIfNotEmpty(provider.get(ATT_USER_INFO_URI)).ifPresent(arg_0 -> ((ClientRegistration.Builder)builder).userInfoUri(arg_0));
        ClientRegistrationsBeanDefinitionParser.getOptionalIfNotEmpty(provider.get(ATT_USER_INFO_AUTHENTICATION_METHOD)).map(AuthenticationMethod::new).ifPresent(arg_0 -> ((ClientRegistration.Builder)builder).userInfoAuthenticationMethod(arg_0));
        ClientRegistrationsBeanDefinitionParser.getOptionalIfNotEmpty(provider.get(ATT_JWK_SET_URI)).ifPresent(arg_0 -> ((ClientRegistration.Builder)builder).jwkSetUri(arg_0));
        ClientRegistrationsBeanDefinitionParser.getOptionalIfNotEmpty(provider.get(ATT_USER_INFO_USER_NAME_ATTRIBUTE)).ifPresent(arg_0 -> ((ClientRegistration.Builder)builder).userNameAttributeName(arg_0));
        return builder;
    }

    private static Optional<String> getOptionalIfNotEmpty(String str) {
        return Optional.ofNullable(str).filter(s -> !s.isEmpty());
    }

    /*
     * Loose catch block
     */
    private static CommonOAuth2Provider getCommonProvider(String providerId) {
        String value;
        block5: {
            value = providerId.trim();
            if (!value.isEmpty()) break block5;
            return null;
            {
                catch (Exception ex) {
                    return null;
                }
            }
        }
        try {
            return CommonOAuth2Provider.valueOf(value);
        }
        catch (Exception ex) {
            return ClientRegistrationsBeanDefinitionParser.findEnum(value);
        }
    }

    private static CommonOAuth2Provider findEnum(String value) {
        String name = ClientRegistrationsBeanDefinitionParser.getCanonicalName(value);
        for (CommonOAuth2Provider candidate : EnumSet.allOf(CommonOAuth2Provider.class)) {
            String candidateName = ClientRegistrationsBeanDefinitionParser.getCanonicalName(candidate.name());
            if (!name.equals(candidateName)) continue;
            return candidate;
        }
        throw new IllegalArgumentException("No enum constant " + CommonOAuth2Provider.class.getCanonicalName() + "." + value);
    }

    private static String getCanonicalName(String name) {
        StringBuilder canonicalName = new StringBuilder(name.length());
        name.chars().filter(Character::isLetterOrDigit).map(Character::toLowerCase).forEach(c -> canonicalName.append((char)c));
        return canonicalName.toString();
    }

    private static String getErrorMessage(String configuredProviderId, String registrationId) {
        return configuredProviderId != null ? "Unknown provider ID '" + configuredProviderId + "'" : "Provider ID must be specified for client registration '" + registrationId + "'";
    }
}

