/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.http.WebConfigUtils;
import org.springframework.security.web.authentication.logout.CookieClearingLogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutSuccessEventPublishingLogoutHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class LogoutBeanDefinitionParser
implements BeanDefinitionParser {
    static final String ATT_LOGOUT_SUCCESS_URL = "logout-success-url";
    static final String ATT_INVALIDATE_SESSION = "invalidate-session";
    static final String ATT_LOGOUT_URL = "logout-url";
    static final String DEF_LOGOUT_URL = "/logout";
    static final String ATT_LOGOUT_HANDLER = "success-handler-ref";
    static final String ATT_DELETE_COOKIES = "delete-cookies";
    final String rememberMeServices;
    private final String defaultLogoutUrl;
    private ManagedList<BeanMetadataElement> logoutHandlers = new ManagedList();
    private boolean csrfEnabled;

    LogoutBeanDefinitionParser(String loginPageUrl, String rememberMeServices, BeanMetadataElement csrfLogoutHandler) {
        this.defaultLogoutUrl = loginPageUrl + "?logout";
        this.rememberMeServices = rememberMeServices;
        boolean bl = this.csrfEnabled = csrfLogoutHandler != null;
        if (this.csrfEnabled) {
            this.logoutHandlers.add((Object)csrfLogoutHandler);
        }
    }

    public BeanDefinition parse(Element element, ParserContext pc) {
        String logoutUrl = null;
        String successHandlerRef = null;
        String logoutSuccessUrl = null;
        String invalidateSession = null;
        String deleteCookies = null;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(LogoutFilter.class);
        if (element != null) {
            Object source = pc.extractSource((Object)element);
            builder.getRawBeanDefinition().setSource(source);
            logoutUrl = element.getAttribute(ATT_LOGOUT_URL);
            successHandlerRef = element.getAttribute(ATT_LOGOUT_HANDLER);
            WebConfigUtils.validateHttpRedirect(logoutUrl, pc, source);
            logoutSuccessUrl = element.getAttribute(ATT_LOGOUT_SUCCESS_URL);
            WebConfigUtils.validateHttpRedirect(logoutSuccessUrl, pc, source);
            invalidateSession = element.getAttribute(ATT_INVALIDATE_SESSION);
            deleteCookies = element.getAttribute(ATT_DELETE_COOKIES);
        }
        if (!StringUtils.hasText(logoutUrl)) {
            logoutUrl = DEF_LOGOUT_URL;
        }
        builder.addPropertyValue("logoutRequestMatcher", (Object)this.getLogoutRequestMatcher(logoutUrl));
        if (StringUtils.hasText(successHandlerRef)) {
            if (StringUtils.hasText(logoutSuccessUrl)) {
                pc.getReaderContext().error("Use logout-success-url or success-handler-ref, but not both", pc.extractSource((Object)element));
            }
            builder.addConstructorArgReference(successHandlerRef);
        } else {
            if (!StringUtils.hasText(logoutSuccessUrl)) {
                logoutSuccessUrl = this.defaultLogoutUrl;
            }
            builder.addConstructorArgValue((Object)logoutSuccessUrl);
        }
        RootBeanDefinition sclh = new RootBeanDefinition(SecurityContextLogoutHandler.class);
        sclh.getPropertyValues().addPropertyValue("invalidateHttpSession", (Object)(!"false".equals(invalidateSession) ? 1 : 0));
        this.logoutHandlers.add((Object)sclh);
        if (this.rememberMeServices != null) {
            this.logoutHandlers.add((Object)new RuntimeBeanReference(this.rememberMeServices));
        }
        if (StringUtils.hasText((String)deleteCookies)) {
            RootBeanDefinition cookieDeleter = new RootBeanDefinition(CookieClearingLogoutHandler.class);
            String[] names = StringUtils.tokenizeToStringArray((String)deleteCookies, (String)",");
            cookieDeleter.getConstructorArgumentValues().addGenericArgumentValue((Object)names);
            this.logoutHandlers.add((Object)cookieDeleter);
        }
        this.logoutHandlers.add((Object)new RootBeanDefinition(LogoutSuccessEventPublishingLogoutHandler.class));
        builder.addConstructorArgValue(this.logoutHandlers);
        return builder.getBeanDefinition();
    }

    private BeanDefinition getLogoutRequestMatcher(String logoutUrl) {
        BeanDefinitionBuilder matcherBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.security.web.util.matcher.AntPathRequestMatcher");
        matcherBuilder.addConstructorArgValue((Object)logoutUrl);
        if (this.csrfEnabled) {
            matcherBuilder.addConstructorArgValue((Object)"POST");
        }
        return matcherBuilder.getBeanDefinition();
    }

    ManagedList<BeanMetadataElement> getLogoutHandlers() {
        return this.logoutHandlers;
    }
}

