/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.userdetails;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.ldap.ppolicy.PasswordPolicyResponseControl;
import org.springframework.security.ldap.userdetails.LdapUserDetailsImpl;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;
import org.springframework.util.Assert;

public class LdapUserDetailsMapper
implements UserDetailsContextMapper {
    private final Log logger = LogFactory.getLog(LdapUserDetailsMapper.class);
    private String passwordAttributeName = "userPassword";
    private String rolePrefix = "ROLE_";
    private String[] roleAttributes = null;
    private boolean convertToUpperCase = true;

    @Override
    public UserDetails mapUserFromContext(DirContextOperations ctx, String username, Collection<? extends GrantedAuthority> authorities) {
        String dn = ctx.getNameInNamespace();
        this.logger.debug((Object)LogMessage.format((String)"Mapping user details from context with DN: %s", (Object)dn));
        LdapUserDetailsImpl.Essence essence = new LdapUserDetailsImpl.Essence();
        essence.setDn(dn);
        Object passwordValue = ctx.getObjectAttribute(this.passwordAttributeName);
        if (passwordValue != null) {
            essence.setPassword(this.mapPassword(passwordValue));
        }
        essence.setUsername(username);
        for (int i = 0; this.roleAttributes != null && i < this.roleAttributes.length; ++i) {
            String[] stringArray = ctx.getStringAttributes(this.roleAttributes[i]);
            if (stringArray == null) {
                this.logger.debug((Object)LogMessage.format((String)"Couldn't read role attribute '%s' for user $s", (Object)this.roleAttributes[i], (Object)dn));
                continue;
            }
            for (String role : stringArray) {
                GrantedAuthority authority = this.createAuthority(role);
                if (authority == null) continue;
                essence.addAuthority(authority);
            }
        }
        for (GrantedAuthority grantedAuthority : authorities) {
            essence.addAuthority(grantedAuthority);
        }
        PasswordPolicyResponseControl ppolicy = (PasswordPolicyResponseControl)ctx.getObjectAttribute("1.3.6.1.4.1.42.2.27.8.5.1");
        if (ppolicy != null) {
            essence.setTimeBeforeExpiration(ppolicy.getTimeBeforeExpiration());
            essence.setGraceLoginsRemaining(ppolicy.getGraceLoginsRemaining());
        }
        return essence.createUserDetails();
    }

    @Override
    public void mapUserToContext(UserDetails user, DirContextAdapter ctx) {
        throw new UnsupportedOperationException("LdapUserDetailsMapper only supports reading from a context. Please use a subclass if mapUserToContext() is required.");
    }

    protected String mapPassword(Object passwordValue) {
        if (!(passwordValue instanceof String)) {
            passwordValue = new String((byte[])passwordValue);
        }
        return (String)passwordValue;
    }

    protected GrantedAuthority createAuthority(Object role) {
        if (role instanceof String) {
            if (this.convertToUpperCase) {
                role = ((String)role).toUpperCase();
            }
            return new SimpleGrantedAuthority(this.rolePrefix + role);
        }
        return null;
    }

    public void setConvertToUpperCase(boolean convertToUpperCase) {
        this.convertToUpperCase = convertToUpperCase;
    }

    public void setPasswordAttributeName(String passwordAttributeName) {
        this.passwordAttributeName = passwordAttributeName;
    }

    public void setRoleAttributes(String[] roleAttributes) {
        Assert.notNull((Object)roleAttributes, (String)"roleAttributes array cannot be null");
        this.roleAttributes = roleAttributes;
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }
}

