/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.registration;

import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONObject;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.RequestEntity;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.util.Assert;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public final class ClientRegistrations {
    private static final String OIDC_METADATA_PATH = "/.well-known/openid-configuration";
    private static final String OAUTH_METADATA_PATH = "/.well-known/oauth-authorization-server";
    private static final RestTemplate rest = new RestTemplate();
    private static final ParameterizedTypeReference<Map<String, Object>> typeReference = new ParameterizedTypeReference<Map<String, Object>>(){};

    public static ClientRegistration.Builder fromOidcIssuerLocation(String issuer) {
        Assert.hasText((String)issuer, (String)"issuer cannot be empty");
        Map<String, Object> configuration = ClientRegistrations.getConfiguration(issuer, ClientRegistrations.oidc(URI.create(issuer)));
        OIDCProviderMetadata metadata = ClientRegistrations.parse(configuration, OIDCProviderMetadata::parse);
        return ClientRegistrations.withProviderConfiguration((AuthorizationServerMetadata)metadata, issuer).userInfoUri(metadata.getUserInfoEndpointURI().toASCIIString());
    }

    public static ClientRegistration.Builder fromIssuerLocation(String issuer) {
        Assert.hasText((String)issuer, (String)"issuer cannot be empty");
        URI uri = URI.create(issuer);
        Map<String, Object> configuration = ClientRegistrations.getConfiguration(issuer, ClientRegistrations.oidc(uri), ClientRegistrations.oidcRfc8414(uri), ClientRegistrations.oauth(uri));
        AuthorizationServerMetadata metadata = ClientRegistrations.parse(configuration, AuthorizationServerMetadata::parse);
        ClientRegistration.Builder builder = ClientRegistrations.withProviderConfiguration(metadata, issuer);
        String userinfoEndpoint = (String)configuration.get("userinfo_endpoint");
        if (userinfoEndpoint != null) {
            builder.userInfoUri(userinfoEndpoint);
        }
        return builder;
    }

    private static URI oidc(URI issuer) {
        return UriComponentsBuilder.fromUri((URI)issuer).replacePath(issuer.getPath() + OIDC_METADATA_PATH).build(Collections.emptyMap());
    }

    private static URI oidcRfc8414(URI issuer) {
        return UriComponentsBuilder.fromUri((URI)issuer).replacePath(OIDC_METADATA_PATH + issuer.getPath()).build(Collections.emptyMap());
    }

    private static URI oauth(URI issuer) {
        return UriComponentsBuilder.fromUri((URI)issuer).replacePath(OAUTH_METADATA_PATH + issuer.getPath()).build(Collections.emptyMap());
    }

    private static Map<String, Object> getConfiguration(String issuer, URI ... uris) {
        String errorMessage = "Unable to resolve Configuration with the provided Issuer of \"" + issuer + "\"";
        for (URI uri : uris) {
            try {
                RequestEntity request = RequestEntity.get((URI)uri).build();
                return (Map)rest.exchange(request, typeReference).getBody();
            }
            catch (HttpClientErrorException e) {
                if (e.getStatusCode().is4xxClientError()) continue;
                throw e;
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException(errorMessage, e);
            }
        }
        throw new IllegalArgumentException(errorMessage);
    }

    private static <T> T parse(Map<String, Object> body, ThrowingFunction<JSONObject, T, ParseException> parser) {
        try {
            return parser.apply(new JSONObject(body));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private static ClientRegistration.Builder withProviderConfiguration(AuthorizationServerMetadata metadata, String issuer) {
        String metadataIssuer = metadata.getIssuer().getValue();
        if (!issuer.equals(metadataIssuer)) {
            throw new IllegalStateException("The Issuer \"" + metadataIssuer + "\" provided in the configuration metadata did not match the requested issuer \"" + issuer + "\"");
        }
        String name = URI.create(issuer).getHost();
        ClientAuthenticationMethod method = ClientRegistrations.getClientAuthenticationMethod(issuer, metadata.getTokenEndpointAuthMethods());
        List grantTypes = metadata.getGrantTypes();
        if (grantTypes != null && !grantTypes.contains(GrantType.AUTHORIZATION_CODE)) {
            throw new IllegalArgumentException("Only AuthorizationGrantType.AUTHORIZATION_CODE is supported. The issuer \"" + issuer + "\" returned a configuration of " + grantTypes);
        }
        List<String> scopes = ClientRegistrations.getScopes(metadata);
        LinkedHashMap<String, Object> configurationMetadata = new LinkedHashMap<String, Object>((Map<String, Object>)metadata.toJSONObject());
        return ClientRegistration.withRegistrationId(name).userNameAttributeName("sub").scope(scopes).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).clientAuthenticationMethod(method).redirectUriTemplate("{baseUrl}/{action}/oauth2/code/{registrationId}").authorizationUri(metadata.getAuthorizationEndpointURI().toASCIIString()).jwkSetUri(metadata.getJWKSetURI().toASCIIString()).providerConfigurationMetadata(configurationMetadata).tokenUri(metadata.getTokenEndpointURI().toASCIIString()).clientName(issuer);
    }

    private static ClientAuthenticationMethod getClientAuthenticationMethod(String issuer, List<com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod> metadataAuthMethods) {
        if (metadataAuthMethods == null || metadataAuthMethods.contains(com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod.CLIENT_SECRET_BASIC)) {
            return ClientAuthenticationMethod.BASIC;
        }
        if (metadataAuthMethods.contains(com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod.CLIENT_SECRET_POST)) {
            return ClientAuthenticationMethod.POST;
        }
        if (metadataAuthMethods.contains(com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod.NONE)) {
            return ClientAuthenticationMethod.NONE;
        }
        throw new IllegalArgumentException("Only ClientAuthenticationMethod.BASIC, ClientAuthenticationMethod.POST and ClientAuthenticationMethod.NONE are supported. The issuer \"" + issuer + "\" returned a configuration of " + metadataAuthMethods);
    }

    private static List<String> getScopes(AuthorizationServerMetadata metadata) {
        Scope scope = metadata.getScopes();
        if (scope == null) {
            return Collections.singletonList("openid");
        }
        return scope.toStringList();
    }

    private ClientRegistrations() {
    }

    private static interface ThrowingFunction<S, T, E extends Throwable> {
        public T apply(S var1) throws E;
    }
}

