/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.registration;

import java.util.Iterator;
import java.util.function.Supplier;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.util.Assert;
import org.springframework.util.function.SingletonSupplier;

public final class SupplierClientRegistrationRepository
implements ClientRegistrationRepository,
Iterable<ClientRegistration> {
    private final Supplier<? extends ClientRegistrationRepository> repositorySupplier;

    public <T extends ClientRegistrationRepository & Iterable<ClientRegistration>> SupplierClientRegistrationRepository(Supplier<T> repositorySupplier) {
        Assert.notNull(repositorySupplier, (String)"repositorySupplier cannot be null");
        this.repositorySupplier = SingletonSupplier.of(repositorySupplier);
    }

    @Override
    public ClientRegistration findByRegistrationId(String registrationId) {
        Assert.hasText((String)registrationId, (String)"registrationId cannot be empty");
        return this.repositorySupplier.get().findByRegistrationId(registrationId);
    }

    @Override
    public Iterator<ClientRegistration> iterator() {
        return ((Iterable)((Object)this.repositorySupplier.get())).iterator();
    }
}

