/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.client;

import java.util.Map;
import java.util.function.Consumer;
import org.springframework.http.HttpRequest;
import org.springframework.security.oauth2.client.web.client.OAuth2ClientHttpRequestInterceptor;
import org.springframework.util.Assert;

public final class RequestAttributeClientRegistrationIdResolver
implements OAuth2ClientHttpRequestInterceptor.ClientRegistrationIdResolver {
    private static final String CLIENT_REGISTRATION_ID_ATTR_NAME = RequestAttributeClientRegistrationIdResolver.class.getName().concat(".clientRegistrationId");

    @Override
    public String resolve(HttpRequest request) {
        return (String)request.getAttributes().get(CLIENT_REGISTRATION_ID_ATTR_NAME);
    }

    public static Consumer<Map<String, Object>> clientRegistrationId(String clientRegistrationId) {
        Assert.hasText((String)clientRegistrationId, (String)"clientRegistrationId cannot be empty");
        return attributes -> attributes.put(CLIENT_REGISTRATION_ID_ATTR_NAME, clientRegistrationId);
    }
}

