/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.core;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.springframework.util.Assert;

public final class Saml2X509Credential {
    private final PrivateKey privateKey;
    private final X509Certificate certificate;
    private final Set<Saml2X509CredentialType> credentialTypes;

    public Saml2X509Credential(X509Certificate certificate, Saml2X509CredentialType ... types) {
        this(null, false, certificate, types);
        this.validateUsages(types, Saml2X509CredentialType.VERIFICATION, Saml2X509CredentialType.ENCRYPTION);
    }

    public Saml2X509Credential(PrivateKey privateKey, X509Certificate certificate, Saml2X509CredentialType ... types) {
        this(privateKey, true, certificate, types);
        this.validateUsages(types, Saml2X509CredentialType.SIGNING, Saml2X509CredentialType.DECRYPTION);
    }

    public Saml2X509Credential(PrivateKey privateKey, X509Certificate certificate, Set<Saml2X509CredentialType> types) {
        Assert.notNull((Object)certificate, (String)"certificate cannot be null");
        Assert.notNull(types, (String)"credentialTypes cannot be null");
        this.privateKey = privateKey;
        this.certificate = certificate;
        this.credentialTypes = types;
    }

    public static Saml2X509Credential encryption(X509Certificate certificate) {
        return new Saml2X509Credential(certificate, Saml2X509CredentialType.ENCRYPTION);
    }

    public static Saml2X509Credential verification(X509Certificate certificate) {
        return new Saml2X509Credential(certificate, Saml2X509CredentialType.VERIFICATION);
    }

    public static Saml2X509Credential decryption(PrivateKey privateKey, X509Certificate certificate) {
        return new Saml2X509Credential(privateKey, certificate, Saml2X509CredentialType.DECRYPTION);
    }

    public static Saml2X509Credential signing(PrivateKey privateKey, X509Certificate certificate) {
        return new Saml2X509Credential(privateKey, certificate, Saml2X509CredentialType.SIGNING);
    }

    private Saml2X509Credential(PrivateKey privateKey, boolean keyRequired, X509Certificate certificate, Saml2X509CredentialType ... types) {
        Assert.notNull((Object)certificate, (String)"certificate cannot be null");
        Assert.notEmpty((Object[])types, (String)"credentials types cannot be empty");
        if (keyRequired) {
            Assert.notNull((Object)privateKey, (String)"privateKey cannot be null");
        }
        this.privateKey = privateKey;
        this.certificate = certificate;
        this.credentialTypes = new LinkedHashSet<Saml2X509CredentialType>(Arrays.asList(types));
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public boolean isSigningCredential() {
        return this.getCredentialTypes().contains((Object)Saml2X509CredentialType.SIGNING);
    }

    public boolean isDecryptionCredential() {
        return this.getCredentialTypes().contains((Object)Saml2X509CredentialType.DECRYPTION);
    }

    public boolean isVerificationCredential() {
        return this.getCredentialTypes().contains((Object)Saml2X509CredentialType.VERIFICATION);
    }

    public boolean isEncryptionCredential() {
        return this.getCredentialTypes().contains((Object)Saml2X509CredentialType.ENCRYPTION);
    }

    public Set<Saml2X509CredentialType> getCredentialTypes() {
        return this.credentialTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Saml2X509Credential that = (Saml2X509Credential)o;
        return Objects.equals(this.privateKey, that.privateKey) && this.certificate.equals(that.certificate) && this.credentialTypes.equals(that.credentialTypes);
    }

    public int hashCode() {
        return Objects.hash(this.privateKey, this.certificate, this.credentialTypes);
    }

    private void validateUsages(Saml2X509CredentialType[] usages, Saml2X509CredentialType ... validUsages) {
        for (Saml2X509CredentialType usage : usages) {
            boolean valid = false;
            for (Saml2X509CredentialType validUsage : validUsages) {
                if (usage != validUsage) continue;
                valid = true;
                break;
            }
            Assert.state((boolean)valid, () -> usage + " is not a valid usage for this credential");
        }
    }

    public static enum Saml2X509CredentialType {
        VERIFICATION,
        ENCRYPTION,
        SIGNING,
        DECRYPTION;

    }
}

