/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.registration;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.provider.service.registration.OpenSamlAssertingPartyDetails;
import org.springframework.security.saml2.provider.service.registration.OpenSamlMetadataUtils;
import org.springframework.security.saml2.provider.service.registration.OpenSamlRelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;

public final class RelyingPartyRegistrations {
    private static final ResourceLoader resourceLoader = new DefaultResourceLoader();

    private RelyingPartyRegistrations() {
    }

    public static RelyingPartyRegistration.Builder fromMetadataLocation(String metadataLocation) {
        RelyingPartyRegistration.Builder builder;
        block9: {
            InputStream source = resourceLoader.getResource(metadataLocation).getInputStream();
            try {
                builder = RelyingPartyRegistrations.fromMetadata(source);
                if (source == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (source != null) {
                        try {
                            source.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    if (ex.getCause() instanceof Saml2Exception) {
                        throw (Saml2Exception)ex.getCause();
                    }
                    throw new Saml2Exception(ex);
                }
            }
            source.close();
        }
        return builder;
    }

    public static RelyingPartyRegistration.Builder fromMetadata(InputStream source) {
        return RelyingPartyRegistrations.collectionFromMetadata(source).iterator().next();
    }

    public static Collection<RelyingPartyRegistration.Builder> collectionFromMetadataLocation(String location) {
        Collection<RelyingPartyRegistration.Builder> collection;
        block9: {
            InputStream source = resourceLoader.getResource(location).getInputStream();
            try {
                collection = RelyingPartyRegistrations.collectionFromMetadata(source);
                if (source == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (source != null) {
                        try {
                            source.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    if (ex.getCause() instanceof Saml2Exception) {
                        throw (Saml2Exception)ex.getCause();
                    }
                    throw new Saml2Exception(ex);
                }
            }
            source.close();
        }
        return collection;
    }

    public static Collection<RelyingPartyRegistration.Builder> collectionFromMetadata(InputStream source) {
        ArrayList<RelyingPartyRegistration.Builder> builders = new ArrayList<RelyingPartyRegistration.Builder>();
        for (EntityDescriptor descriptor : OpenSamlMetadataUtils.descriptors(source)) {
            if (descriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol") == null) continue;
            OpenSamlAssertingPartyDetails assertingParty = OpenSamlAssertingPartyDetails.withEntityDescriptor(descriptor).build();
            builders.add(new OpenSamlRelyingPartyRegistration.Builder(assertingParty));
        }
        if (builders.isEmpty()) {
            throw new Saml2Exception("Metadata response is missing the necessary IDPSSODescriptor element");
        }
        return builders;
    }
}

