/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web.authentication.logout;

import jakarta.servlet.http.HttpServletRequest;
import java.time.Clock;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml.saml2.core.impl.LogoutRequestBuilder;
import org.opensaml.saml.saml2.core.impl.LogoutRequestMarshaller;
import org.opensaml.saml.saml2.core.impl.NameIDBuilder;
import org.opensaml.saml.saml2.core.impl.SessionIndexBuilder;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.Authentication;
import org.springframework.security.saml2.core.OpenSamlInitializationService;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticatedPrincipal;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutRequest;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationPlaceholderResolvers;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.OpenSamlOperations;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutRequestResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2Utils;
import org.springframework.util.Assert;

final class BaseOpenSamlLogoutRequestResolver
implements Saml2LogoutRequestResolver {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final OpenSamlOperations saml;
    private Clock clock = Clock.systemUTC();
    private final LogoutRequestMarshaller marshaller;
    private final IssuerBuilder issuerBuilder;
    private final NameIDBuilder nameIdBuilder;
    private final SessionIndexBuilder sessionIndexBuilder;
    private final LogoutRequestBuilder logoutRequestBuilder;
    private final RelyingPartyRegistrationResolver relyingPartyRegistrationResolver;
    private Converter<HttpServletRequest, String> relayStateResolver = request -> UUID.randomUUID().toString();
    private Consumer<LogoutRequestParameters> parametersConsumer = parameters -> {};

    BaseOpenSamlLogoutRequestResolver(RelyingPartyRegistrationResolver relyingPartyRegistrationResolver, OpenSamlOperations saml) {
        this.relyingPartyRegistrationResolver = relyingPartyRegistrationResolver;
        this.saml = saml;
        XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
        this.marshaller = (LogoutRequestMarshaller)registry.getMarshallerFactory().getMarshaller(LogoutRequest.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.marshaller, (String)"logoutRequestMarshaller must be configured in OpenSAML");
        this.logoutRequestBuilder = (LogoutRequestBuilder)registry.getBuilderFactory().getBuilder(LogoutRequest.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.logoutRequestBuilder, (String)"logoutRequestBuilder must be configured in OpenSAML");
        this.issuerBuilder = (IssuerBuilder)registry.getBuilderFactory().getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.issuerBuilder, (String)"issuerBuilder must be configured in OpenSAML");
        this.nameIdBuilder = (NameIDBuilder)registry.getBuilderFactory().getBuilder(NameID.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.nameIdBuilder, (String)"nameIdBuilder must be configured in OpenSAML");
        this.sessionIndexBuilder = (SessionIndexBuilder)registry.getBuilderFactory().getBuilder(SessionIndex.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.sessionIndexBuilder, (String)"sessionIndexBuilder must be configured in OpenSAML");
    }

    void setClock(Clock clock) {
        this.clock = clock;
    }

    void setRelayStateResolver(Converter<HttpServletRequest, String> relayStateResolver) {
        this.relayStateResolver = relayStateResolver;
    }

    void setParametersConsumer(Consumer<LogoutRequestParameters> parametersConsumer) {
        this.parametersConsumer = parametersConsumer;
    }

    @Override
    public Saml2LogoutRequest resolve(HttpServletRequest request, Authentication authentication) {
        String xml;
        String registrationId = this.getRegistrationId(authentication);
        RelyingPartyRegistration registration = this.relyingPartyRegistrationResolver.resolve(request, registrationId);
        if (registration == null) {
            return null;
        }
        if (registration.getAssertingPartyMetadata().getSingleLogoutServiceLocation() == null) {
            return null;
        }
        RelyingPartyRegistrationPlaceholderResolvers.UriResolver uriResolver = RelyingPartyRegistrationPlaceholderResolvers.uriResolver(request, registration);
        String entityId = uriResolver.resolve(registration.getEntityId());
        LogoutRequest logoutRequest = this.logoutRequestBuilder.buildObject();
        logoutRequest.setDestination(registration.getAssertingPartyMetadata().getSingleLogoutServiceLocation());
        Issuer issuer = this.issuerBuilder.buildObject();
        issuer.setValue(entityId);
        logoutRequest.setIssuer(issuer);
        NameID nameId = this.nameIdBuilder.buildObject();
        nameId.setValue(authentication.getName());
        logoutRequest.setNameID(nameId);
        if (authentication.getPrincipal() instanceof Saml2AuthenticatedPrincipal) {
            Saml2AuthenticatedPrincipal principal = (Saml2AuthenticatedPrincipal)authentication.getPrincipal();
            for (String index : principal.getSessionIndexes()) {
                SessionIndex sessionIndex = this.sessionIndexBuilder.buildObject();
                sessionIndex.setValue(index);
                logoutRequest.getSessionIndexes().add(sessionIndex);
            }
        }
        logoutRequest.setIssueInstant(Instant.now(this.clock));
        this.parametersConsumer.accept(new LogoutRequestParameters(request, registration, authentication, logoutRequest));
        if (logoutRequest.getID() == null) {
            logoutRequest.setID("LR" + UUID.randomUUID());
        }
        String relayState = (String)this.relayStateResolver.convert((Object)request);
        Saml2LogoutRequest.Builder result = Saml2LogoutRequest.withRelyingPartyRegistration(registration).id(logoutRequest.getID());
        if (registration.getAssertingPartyMetadata().getSingleLogoutServiceBinding() == Saml2MessageBinding.POST) {
            xml = this.serialize(this.saml.withSigningKeys(registration.getSigningX509Credentials()).algorithms(registration.getAssertingPartyMetadata().getSigningAlgorithms()).sign((LogoutRequest)logoutRequest));
            String samlRequest = Saml2Utils.withDecoded(xml).encode();
            return result.samlRequest(samlRequest).relayState(relayState).build();
        }
        xml = this.serialize(logoutRequest);
        String deflatedAndEncoded = Saml2Utils.withDecoded(xml).deflate(true).encode();
        result.samlRequest(deflatedAndEncoded);
        HashMap<String, String> signingParameters = new HashMap<String, String>();
        signingParameters.put("SAMLRequest", deflatedAndEncoded);
        signingParameters.put("RelayState", relayState);
        Map<String, String> query = this.saml.withSigningKeys(registration.getSigningX509Credentials()).algorithms(registration.getAssertingPartyMetadata().getSigningAlgorithms()).sign(signingParameters);
        return result.parameters(params -> params.putAll(query)).build();
    }

    private String getRegistrationId(Authentication authentication) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Attempting to resolve registrationId from " + authentication));
        }
        if (authentication == null) {
            return null;
        }
        Object principal = authentication.getPrincipal();
        if (principal instanceof Saml2AuthenticatedPrincipal) {
            return ((Saml2AuthenticatedPrincipal)principal).getRelyingPartyRegistrationId();
        }
        return null;
    }

    private String serialize(LogoutRequest logoutRequest) {
        return this.saml.serialize((XMLObject)logoutRequest).serialize();
    }

    static {
        OpenSamlInitializationService.initialize();
    }

    static final class LogoutRequestParameters {
        private final HttpServletRequest request;
        private final RelyingPartyRegistration registration;
        private final Authentication authentication;
        private final LogoutRequest logoutRequest;

        LogoutRequestParameters(HttpServletRequest request, RelyingPartyRegistration registration, Authentication authentication, LogoutRequest logoutRequest) {
            this.request = request;
            this.registration = registration;
            this.authentication = authentication;
            this.logoutRequest = logoutRequest;
        }

        HttpServletRequest getRequest() {
            return this.request;
        }

        RelyingPartyRegistration getRelyingPartyRegistration() {
            return this.registration;
        }

        Authentication getAuthentication() {
            return this.authentication;
        }

        LogoutRequest getLogoutRequest() {
            return this.logoutRequest;
        }
    }
}

