/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.test.context;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;

public final class TestSecurityContextHolder {
    private static final ThreadLocal<SecurityContext> contextHolder = new ThreadLocal();

    public static void clearContext() {
        contextHolder.remove();
        SecurityContextHolder.clearContext();
    }

    public static SecurityContext getContext() {
        SecurityContext ctx = contextHolder.get();
        if (ctx == null) {
            ctx = TestSecurityContextHolder.getDefaultContext();
            contextHolder.set(ctx);
        }
        return ctx;
    }

    public static void setContext(SecurityContext context) {
        Assert.notNull((Object)context, (String)"Only non-null SecurityContext instances are permitted");
        contextHolder.set(context);
        SecurityContextHolder.setContext((SecurityContext)context);
    }

    public static void setAuthentication(Authentication authentication) {
        Assert.notNull((Object)authentication, (String)"Only non-null Authentication instances are permitted");
        SecurityContext context = SecurityContextHolder.createEmptyContext();
        context.setAuthentication(authentication);
        TestSecurityContextHolder.setContext(context);
    }

    private static SecurityContext getDefaultContext() {
        return SecurityContextHolder.getContext();
    }

    private TestSecurityContextHolder() {
    }
}

