/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.server.handler.DefaultWebFilterChain;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class WebFilterChainProxy
implements WebFilter {
    private final List<SecurityWebFilterChain> filters;
    private WebFilterChainDecorator filterChainDecorator = new DefaultWebFilterChainDecorator();

    public WebFilterChainProxy(List<SecurityWebFilterChain> filters) {
        this.filters = filters;
    }

    public WebFilterChainProxy(SecurityWebFilterChain ... filters) {
        this.filters = Arrays.asList(filters);
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return Flux.fromIterable(this.filters).filterWhen(securityWebFilterChain -> securityWebFilterChain.matches(exchange)).next().switchIfEmpty(Mono.defer(() -> this.filterChainDecorator.decorate(chain).filter(exchange).then(Mono.empty()))).flatMap(securityWebFilterChain -> securityWebFilterChain.getWebFilters().collectList()).map(filters -> this.filterChainDecorator.decorate(chain, (List<WebFilter>)filters)).flatMap(securedChain -> securedChain.filter(exchange));
    }

    public void setFilterChainDecorator(WebFilterChainDecorator filterChainDecorator) {
        Assert.notNull((Object)filterChainDecorator, (String)"filterChainDecorator cannot be null");
        this.filterChainDecorator = filterChainDecorator;
    }

    public static class DefaultWebFilterChainDecorator
    implements WebFilterChainDecorator {
        @Override
        public WebFilterChain decorate(WebFilterChain original) {
            return original;
        }

        @Override
        public WebFilterChain decorate(WebFilterChain original, List<WebFilter> filters) {
            return new DefaultWebFilterChain(arg_0 -> ((WebFilterChain)original).filter(arg_0), filters);
        }
    }

    public static interface WebFilterChainDecorator {
        default public WebFilterChain decorate(WebFilterChain original) {
            return this.decorate(original, Collections.emptyList());
        }

        public WebFilterChain decorate(WebFilterChain var1, List<WebFilter> var2);
    }
}

