/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.api;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import org.springframework.util.Assert;

public final class Bytes {
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final Base64.Encoder ENCODER = Base64.getUrlEncoder().withoutPadding();
    private static final Base64.Decoder DECODER = Base64.getUrlDecoder();
    private final byte[] bytes;

    public Bytes(byte[] bytes) {
        Assert.notNull((Object)bytes, (String)"bytes cannot be null");
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    public String toBase64UrlString() {
        return ENCODER.encodeToString(this.getBytes());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Bytes) {
            Bytes that = (Bytes)obj;
            return that.toBase64UrlString().equals(this.toBase64UrlString());
        }
        return false;
    }

    public int hashCode() {
        return this.toBase64UrlString().hashCode();
    }

    public String toString() {
        return "Bytes[" + this.toBase64UrlString() + "]";
    }

    public static Bytes random() {
        byte[] bytes = new byte[32];
        RANDOM.nextBytes(bytes);
        return new Bytes(bytes);
    }

    public static Bytes fromBase64(String base64UrlString) {
        byte[] bytes = DECODER.decode(base64UrlString);
        return new Bytes(bytes);
    }
}

