/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.authentication;

import java.util.Collection;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.web.webauthn.management.RelyingPartyAuthenticationRequest;
import org.springframework.util.Assert;

public class WebAuthnAuthenticationRequestToken
extends AbstractAuthenticationToken {
    private final RelyingPartyAuthenticationRequest webAuthnRequest;

    public WebAuthnAuthenticationRequestToken(RelyingPartyAuthenticationRequest webAuthnRequest) {
        super((Collection)AuthorityUtils.NO_AUTHORITIES);
        Assert.notNull((Object)webAuthnRequest, (String)"webAuthnRequest cannot be null");
        this.webAuthnRequest = webAuthnRequest;
    }

    public RelyingPartyAuthenticationRequest getWebAuthnRequest() {
        return this.webAuthnRequest;
    }

    public void setAuthenticated(boolean authenticated) {
        Assert.isTrue((!authenticated ? 1 : 0) != 0, (String)"Cannot set this token to trusted");
        super.setAuthenticated(authenticated);
    }

    public Object getCredentials() {
        return this.webAuthnRequest.getPublicKey();
    }

    public Object getPrincipal() {
        return this.webAuthnRequest.getPublicKey().getResponse().getUserHandle();
    }
}

