/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.redis.config.annotation.web.server;

import java.time.Duration;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.ReactiveRedisOperations;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import org.springframework.session.IndexResolver;
import org.springframework.session.ReactiveSessionRepository;
import org.springframework.session.SaveMode;
import org.springframework.session.Session;
import org.springframework.session.data.redis.ReactiveRedisIndexedSessionRepository;
import org.springframework.session.data.redis.config.ConfigureReactiveRedisAction;
import org.springframework.session.data.redis.config.annotation.ConfigureNotifyKeyspaceEventsReactiveAction;
import org.springframework.session.data.redis.config.annotation.web.server.AbstractRedisWebSessionConfiguration;
import org.springframework.session.data.redis.config.annotation.web.server.EnableRedisIndexedWebSession;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

@Configuration(proxyBeanMethods=false)
public class RedisIndexedWebSessionConfiguration
extends AbstractRedisWebSessionConfiguration<ReactiveRedisIndexedSessionRepository>
implements EmbeddedValueResolverAware,
ImportAware {
    private static final boolean lettucePresent;
    private static final boolean jedisPresent;
    private ConfigureReactiveRedisAction configureRedisAction = new ConfigureNotifyKeyspaceEventsReactiveAction();
    private StringValueResolver embeddedValueResolver;
    private ApplicationEventPublisher eventPublisher;
    private IndexResolver<Session> indexResolver;

    @Override
    @Bean
    public ReactiveRedisIndexedSessionRepository sessionRepository() {
        ReactiveRedisTemplate<String, Object> reactiveRedisTemplate = this.createReactiveRedisTemplate();
        ReactiveRedisIndexedSessionRepository sessionRepository = new ReactiveRedisIndexedSessionRepository((ReactiveRedisOperations<String, Object>)reactiveRedisTemplate, (ReactiveRedisTemplate<String, String>)this.createReactiveStringRedisTemplate());
        sessionRepository.setDefaultMaxInactiveInterval(this.getMaxInactiveInterval());
        sessionRepository.setEventPublisher(this.eventPublisher);
        if (this.indexResolver != null) {
            sessionRepository.setIndexResolver(this.indexResolver);
        }
        if (StringUtils.hasText((String)this.getRedisNamespace())) {
            sessionRepository.setRedisKeyNamespace(this.getRedisNamespace());
        }
        int database = this.resolveDatabase();
        sessionRepository.setDatabase(database);
        sessionRepository.setSaveMode(this.getSaveMode());
        sessionRepository.setSessionIdGenerator(this.getSessionIdGenerator());
        if (this.getSessionRepositoryCustomizers() != null) {
            this.getSessionRepositoryCustomizers().forEach(customizer -> customizer.customize((ReactiveSessionRepository)sessionRepository));
        }
        return sessionRepository;
    }

    private ReactiveStringRedisTemplate createReactiveStringRedisTemplate() {
        return new ReactiveStringRedisTemplate(this.getRedisConnectionFactory());
    }

    @Bean
    public InitializingBean enableRedisKeyspaceNotificationsInitializer() {
        return new EnableRedisKeyspaceNotificationsInitializer(this.getRedisConnectionFactory(), this.configureRedisAction);
    }

    @Autowired
    public void setEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Autowired(required=false)
    public void setConfigureRedisAction(ConfigureReactiveRedisAction configureRedisAction) {
        this.configureRedisAction = configureRedisAction;
    }

    @Autowired(required=false)
    public void setIndexResolver(IndexResolver<Session> indexResolver) {
        this.indexResolver = indexResolver;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Map attributeMap = importMetadata.getAnnotationAttributes(EnableRedisIndexedWebSession.class.getName());
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)attributeMap);
        if (attributes == null) {
            return;
        }
        this.setMaxInactiveInterval(Duration.ofSeconds(((Integer)attributes.getNumber("maxInactiveIntervalInSeconds")).intValue()));
        String redisNamespaceValue = attributes.getString("redisNamespace");
        if (StringUtils.hasText((String)redisNamespaceValue)) {
            this.setRedisNamespace(this.embeddedValueResolver.resolveStringValue(redisNamespaceValue));
        }
        this.setSaveMode((SaveMode)attributes.getEnum("saveMode"));
    }

    private int resolveDatabase() {
        ReactiveRedisConnectionFactory reactiveRedisConnectionFactory;
        if (lettucePresent && (reactiveRedisConnectionFactory = this.getRedisConnectionFactory()) instanceof LettuceConnectionFactory) {
            LettuceConnectionFactory lettuce = (LettuceConnectionFactory)reactiveRedisConnectionFactory;
            return lettuce.getDatabase();
        }
        if (jedisPresent && (reactiveRedisConnectionFactory = this.getRedisConnectionFactory()) instanceof JedisConnectionFactory) {
            JedisConnectionFactory jedis = (JedisConnectionFactory)reactiveRedisConnectionFactory;
            return jedis.getDatabase();
        }
        return 0;
    }

    static {
        ClassLoader classLoader = RedisIndexedWebSessionConfiguration.class.getClassLoader();
        lettucePresent = ClassUtils.isPresent((String)"io.lettuce.core.RedisClient", (ClassLoader)classLoader);
        jedisPresent = ClassUtils.isPresent((String)"redis.clients.jedis.Jedis", (ClassLoader)classLoader);
    }

    static class EnableRedisKeyspaceNotificationsInitializer
    implements InitializingBean {
        private final ReactiveRedisConnectionFactory connectionFactory;
        private final ConfigureReactiveRedisAction configure;

        EnableRedisKeyspaceNotificationsInitializer(ReactiveRedisConnectionFactory connectionFactory, ConfigureReactiveRedisAction configure) {
            this.connectionFactory = connectionFactory;
            this.configure = configure;
        }

        public void afterPropertiesSet() {
            if (this.configure == ConfigureReactiveRedisAction.NO_OP) {
                return;
            }
            ReactiveRedisConnection connection = this.connectionFactory.getReactiveConnection();
            try {
                this.configure.configure(connection).block();
            }
            finally {
                try {
                    connection.close();
                }
                catch (Exception ex) {
                    LogFactory.getLog(this.getClass()).error((Object)"Error closing RedisConnection", (Throwable)ex);
                }
            }
        }
    }
}

