/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.hazelcast;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.IMap;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.EntryEvictedListener;
import com.hazelcast.map.listener.EntryRemovedListener;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.query.Predicates;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.session.ExpiringSession;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.MapSession;
import org.springframework.session.Session;
import org.springframework.session.events.SessionCreatedEvent;
import org.springframework.session.events.SessionDeletedEvent;
import org.springframework.session.events.SessionExpiredEvent;
import org.springframework.session.hazelcast.HazelcastFlushMode;
import org.springframework.session.hazelcast.SessionUpdateEntryProcessor;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HazelcastSessionRepository
implements FindByIndexNameSessionRepository<HazelcastSession>,
EntryAddedListener<String, MapSession>,
EntryEvictedListener<String, MapSession>,
EntryRemovedListener<String, MapSession> {
    public static final String PRINCIPAL_NAME_ATTRIBUTE = "principalName";
    private static final Log logger = LogFactory.getLog(HazelcastSessionRepository.class);
    private final IMap<String, MapSession> sessions;
    private HazelcastFlushMode hazelcastFlushMode = HazelcastFlushMode.ON_SAVE;
    private ApplicationEventPublisher eventPublisher = new ApplicationEventPublisher(){

        public void publishEvent(ApplicationEvent event) {
        }

        public void publishEvent(Object event) {
        }
    };
    private Integer defaultMaxInactiveInterval;
    private String sessionListenerId;

    public HazelcastSessionRepository(IMap<String, MapSession> sessions) {
        Assert.notNull(sessions, (String)"Sessions IMap must not be null");
        this.sessions = sessions;
    }

    @PostConstruct
    private void init() {
        this.sessionListenerId = this.sessions.addEntryListener((MapListener)this, true);
    }

    @PreDestroy
    private void close() {
        this.sessions.removeEntryListener(this.sessionListenerId);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        Assert.notNull((Object)applicationEventPublisher, (String)"ApplicationEventPublisher cannot be null");
        this.eventPublisher = applicationEventPublisher;
    }

    public void setDefaultMaxInactiveInterval(Integer defaultMaxInactiveInterval) {
        this.defaultMaxInactiveInterval = defaultMaxInactiveInterval;
    }

    public void setHazelcastFlushMode(HazelcastFlushMode hazelcastFlushMode) {
        Assert.notNull((Object)((Object)hazelcastFlushMode), (String)"HazelcastFlushMode cannot be null");
        this.hazelcastFlushMode = hazelcastFlushMode;
    }

    @Override
    public HazelcastSession createSession() {
        HazelcastSession result = new HazelcastSession();
        if (this.defaultMaxInactiveInterval != null) {
            result.setMaxInactiveIntervalInSeconds(this.defaultMaxInactiveInterval);
        }
        return result;
    }

    @Override
    public void save(HazelcastSession session) {
        if (session.isNew) {
            this.sessions.set((Object)session.getId(), (Object)session.getDelegate(), (long)session.getMaxInactiveIntervalInSeconds(), TimeUnit.SECONDS);
        } else if (session.hasChanges()) {
            SessionUpdateEntryProcessor entryProcessor = new SessionUpdateEntryProcessor();
            if (session.lastAccessedTimeChanged) {
                entryProcessor.setLastAccessedTime(session.getLastAccessedTime());
            }
            if (session.maxInactiveIntervalChanged) {
                entryProcessor.setMaxInactiveInterval(session.getMaxInactiveIntervalInSeconds());
            }
            if (!session.delta.isEmpty()) {
                entryProcessor.setDelta(session.delta);
            }
            this.sessions.executeOnKey((Object)session.getId(), (EntryProcessor)entryProcessor);
        }
        session.clearChangeFlags();
    }

    @Override
    public HazelcastSession getSession(String id) {
        MapSession saved = (MapSession)this.sessions.get((Object)id);
        if (saved == null) {
            return null;
        }
        if (saved.isExpired()) {
            this.delete(saved.getId());
            return null;
        }
        return new HazelcastSession(saved);
    }

    @Override
    public void delete(String id) {
        this.sessions.remove((Object)id);
    }

    @Override
    public Map<String, HazelcastSession> findByIndexNameAndIndexValue(String indexName, String indexValue) {
        if (!PRINCIPAL_NAME_INDEX_NAME.equals(indexName)) {
            return Collections.emptyMap();
        }
        Collection sessions = this.sessions.values(Predicates.equal((String)PRINCIPAL_NAME_ATTRIBUTE, (Comparable)((Object)indexValue)));
        HashMap<String, HazelcastSession> sessionMap = new HashMap<String, HazelcastSession>(sessions.size());
        for (MapSession session : sessions) {
            sessionMap.put(session.getId(), new HazelcastSession(session));
        }
        return sessionMap;
    }

    public void entryAdded(EntryEvent<String, MapSession> event) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Session created with id: " + ((MapSession)event.getValue()).getId()));
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new SessionCreatedEvent((Object)this, (Session)event.getValue()));
    }

    public void entryEvicted(EntryEvent<String, MapSession> event) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Session expired with id: " + ((MapSession)event.getOldValue()).getId()));
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new SessionExpiredEvent((Object)this, (Session)event.getOldValue()));
    }

    public void entryRemoved(EntryEvent<String, MapSession> event) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Session deleted with id: " + ((MapSession)event.getOldValue()).getId()));
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new SessionDeletedEvent((Object)this, (Session)event.getOldValue()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class HazelcastSession
    implements ExpiringSession {
        private final MapSession delegate;
        private boolean isNew;
        private boolean sessionIdChanged;
        private boolean lastAccessedTimeChanged;
        private boolean maxInactiveIntervalChanged;
        private Map<String, Object> delta = new HashMap<String, Object>();

        HazelcastSession() {
            this(new MapSession());
            this.isNew = true;
            this.flushImmediateIfNecessary();
        }

        HazelcastSession(MapSession cached) {
            Assert.notNull((Object)cached, (String)"MapSession cannot be null");
            this.delegate = cached;
        }

        @Override
        public void setLastAccessedTime(long lastAccessedTime) {
            this.delegate.setLastAccessedTime(lastAccessedTime);
            this.lastAccessedTimeChanged = true;
            this.flushImmediateIfNecessary();
        }

        @Override
        public boolean isExpired() {
            return this.delegate.isExpired();
        }

        @Override
        public long getCreationTime() {
            return this.delegate.getCreationTime();
        }

        @Override
        public String getId() {
            return this.delegate.getId();
        }

        @Override
        public long getLastAccessedTime() {
            return this.delegate.getLastAccessedTime();
        }

        @Override
        public void setMaxInactiveIntervalInSeconds(int interval) {
            this.delegate.setMaxInactiveIntervalInSeconds(interval);
            this.maxInactiveIntervalChanged = true;
            this.flushImmediateIfNecessary();
        }

        @Override
        public int getMaxInactiveIntervalInSeconds() {
            return this.delegate.getMaxInactiveIntervalInSeconds();
        }

        @Override
        public <T> T getAttribute(String attributeName) {
            return this.delegate.getAttribute(attributeName);
        }

        @Override
        public Set<String> getAttributeNames() {
            return this.delegate.getAttributeNames();
        }

        @Override
        public void setAttribute(String attributeName, Object attributeValue) {
            this.delegate.setAttribute(attributeName, attributeValue);
            this.delta.put(attributeName, attributeValue);
            this.flushImmediateIfNecessary();
        }

        @Override
        public void removeAttribute(String attributeName) {
            this.delegate.removeAttribute(attributeName);
            this.delta.put(attributeName, null);
            this.flushImmediateIfNecessary();
        }

        MapSession getDelegate() {
            return this.delegate;
        }

        boolean hasChanges() {
            return this.lastAccessedTimeChanged || this.maxInactiveIntervalChanged || !this.delta.isEmpty();
        }

        void clearChangeFlags() {
            this.isNew = false;
            this.lastAccessedTimeChanged = false;
            this.sessionIdChanged = false;
            this.maxInactiveIntervalChanged = false;
            this.delta.clear();
        }

        private void flushImmediateIfNecessary() {
            if (HazelcastSessionRepository.this.hazelcastFlushMode == HazelcastFlushMode.IMMEDIATE) {
                HazelcastSessionRepository.this.save(this);
            }
        }
    }
}

