/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.hazelcast;

import com.hazelcast.map.AbstractEntryProcessor;
import java.util.Map;
import org.springframework.session.MapSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionUpdateEntryProcessor
extends AbstractEntryProcessor<String, MapSession> {
    private long lastAccessedTime;
    private boolean lastAccessedTimeSet;
    private int maxInactiveInterval;
    private boolean maxInactiveIntervalSet;
    private Map<String, Object> delta;

    public Object process(Map.Entry<String, MapSession> entry) {
        MapSession value = entry.getValue();
        if (value == null) {
            return Boolean.FALSE;
        }
        if (this.lastAccessedTimeSet) {
            value.setLastAccessedTime(this.lastAccessedTime);
        }
        if (this.maxInactiveIntervalSet) {
            value.setMaxInactiveIntervalInSeconds(this.maxInactiveInterval);
        }
        if (this.delta != null) {
            for (Map.Entry<String, Object> attribute : this.delta.entrySet()) {
                if (attribute.getValue() != null) {
                    value.setAttribute(attribute.getKey(), attribute.getValue());
                    continue;
                }
                value.removeAttribute(attribute.getKey());
            }
        }
        entry.setValue(value);
        return Boolean.TRUE;
    }

    void setLastAccessedTime(long lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
        this.lastAccessedTimeSet = true;
    }

    void setMaxInactiveInterval(int maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
        this.maxInactiveIntervalSet = true;
    }

    void setDelta(Map<String, Object> delta) {
        this.delta = delta;
    }
}

