/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.security;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.session.ExpiringSession;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.security.SpringSessionBackedSessionInformation;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringSessionBackedSessionRegistry
implements SessionRegistry {
    private final FindByIndexNameSessionRepository<ExpiringSession> sessionRepository;

    public SpringSessionBackedSessionRegistry(FindByIndexNameSessionRepository<ExpiringSession> sessionRepository) {
        Assert.notNull(sessionRepository, (String)"sessionRepository cannot be null");
        this.sessionRepository = sessionRepository;
    }

    public List<Object> getAllPrincipals() {
        throw new UnsupportedOperationException("SpringSessionBackedSessionRegistry does not support retrieving all principals, since Spring Session provides no way to obtain that information");
    }

    public List<SessionInformation> getAllSessions(Object principal, boolean includeExpiredSessions) {
        Collection<ExpiringSession> sessions = this.sessionRepository.findByIndexNameAndIndexValue(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME, this.name(principal)).values();
        ArrayList<SessionInformation> infos = new ArrayList<SessionInformation>();
        for (ExpiringSession session : sessions) {
            if (!includeExpiredSessions && Boolean.TRUE.equals(session.getAttribute(SpringSessionBackedSessionInformation.EXPIRED_ATTR))) continue;
            infos.add(new SpringSessionBackedSessionInformation(session, this.sessionRepository));
        }
        return infos;
    }

    public SessionInformation getSessionInformation(String sessionId) {
        ExpiringSession session = (ExpiringSession)this.sessionRepository.getSession(sessionId);
        if (session != null) {
            return new SpringSessionBackedSessionInformation(session, this.sessionRepository);
        }
        return null;
    }

    public void refreshLastRequest(String sessionId) {
    }

    public void registerNewSession(String sessionId, Object principal) {
    }

    public void removeSessionInformation(String sessionId) {
    }

    protected String name(Object principal) {
        if (principal instanceof UserDetails) {
            return ((UserDetails)principal).getUsername();
        }
        if (principal instanceof Principal) {
            return ((Principal)principal).getName();
        }
        return principal.toString();
    }
}

