/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.AbstractRegexpMethodPointcut;
import org.springframework.aop.support.JdkRegexpMethodPointcut;
import org.springframework.aop.support.Perl5RegexpMethodPointcut;
import org.springframework.core.JdkVersion;

public class RegexpMethodPointcutAdvisor
extends AbstractPointcutAdvisor {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private String[] patterns;
    private boolean perl5 = false;
    private AbstractRegexpMethodPointcut pointcut;

    public RegexpMethodPointcutAdvisor() {
    }

    public RegexpMethodPointcutAdvisor(Advice advice) {
        this.setAdvice(advice);
    }

    public RegexpMethodPointcutAdvisor(String pattern, Advice advice) {
        this.setPattern(pattern);
        this.setAdvice(advice);
    }

    public RegexpMethodPointcutAdvisor(String[] patterns, Advice advice) {
        this.setPatterns(patterns);
        this.setAdvice(advice);
    }

    public void setPattern(String pattern) {
        this.setPatterns(new String[]{pattern});
    }

    public void setPatterns(String[] patterns) {
        this.patterns = patterns;
    }

    public void setPerl5(boolean perl5) {
        this.perl5 = perl5;
    }

    public synchronized Pointcut getPointcut() {
        if (this.pointcut == null) {
            this.pointcut = this.createPointcut();
            this.pointcut.setPatterns(this.patterns);
        }
        return this.pointcut;
    }

    protected AbstractRegexpMethodPointcut createPointcut() {
        if (this.perl5 || JdkVersion.getMajorJavaVersion() < 1) {
            this.logger.debug((Object)"Creating Perl5RegexpMethodPointcut (Jakarta ORO needs to be available)");
            return Perl5RegexpPointcutFactory.createPerl5RegexpPointcut();
        }
        this.logger.debug((Object)"Creating JdkRegexpMethodPointcut");
        return new JdkRegexpMethodPointcut();
    }

    private static class Perl5RegexpPointcutFactory {
        private Perl5RegexpPointcutFactory() {
        }

        public static AbstractRegexpMethodPointcut createPerl5RegexpPointcut() {
            return new Perl5RegexpMethodPointcut();
        }
    }
}

