/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GeneratedMethods;
import org.springframework.beans.factory.aot.ResolvableTypeCodeGenerator;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.core.ResolvableType;
import org.springframework.javapoet.AnnotationSpec;
import org.springframework.javapoet.CodeBlock;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

class BeanDefinitionPropertyValueCodeGenerator {
    static final CodeBlock NULL_VALUE_CODE_BLOCK = CodeBlock.of((String)"null", (Object[])new Object[0]);
    private final GeneratedMethods generatedMethods;
    private final List<Delegate> delegates;

    BeanDefinitionPropertyValueCodeGenerator(GeneratedMethods generatedMethods, @Nullable BiFunction<Object, ResolvableType, CodeBlock> customValueGenerator) {
        this.generatedMethods = generatedMethods;
        this.delegates = new ArrayList<Delegate>();
        if (customValueGenerator != null) {
            this.delegates.add(customValueGenerator::apply);
        }
        this.delegates.addAll(List.of(new PrimitiveDelegate(), new StringDelegate(), new CharsetDelegate(), new EnumDelegate(), new ClassDelegate(), new ResolvableTypeDelegate(), new ArrayDelegate(), new ManagedListDelegate(), new ManagedSetDelegate(), new ManagedMapDelegate(), new ListDelegate(), new SetDelegate(), new MapDelegate(), new BeanReferenceDelegate()));
    }

    CodeBlock generateCode(@Nullable Object value) {
        ResolvableType type = ResolvableType.forInstance((Object)value);
        try {
            return this.generateCode(value, type);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(BeanDefinitionPropertyValueCodeGenerator.buildErrorMessage(value, type), ex);
        }
    }

    private CodeBlock generateCodeForElement(@Nullable Object value, ResolvableType type) {
        try {
            return this.generateCode(value, type);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(BeanDefinitionPropertyValueCodeGenerator.buildErrorMessage(value, type), ex);
        }
    }

    private static String buildErrorMessage(@Nullable Object value, ResolvableType type) {
        StringBuilder message = new StringBuilder("Failed to generate code for '");
        message.append(value).append("'");
        if (type != ResolvableType.NONE) {
            message.append(" with type ").append(type);
        }
        return message.toString();
    }

    private CodeBlock generateCode(@Nullable Object value, ResolvableType type) {
        if (value == null) {
            return NULL_VALUE_CODE_BLOCK;
        }
        for (Delegate delegate : this.delegates) {
            CodeBlock code = delegate.generateCode(value, type);
            if (code == null) continue;
            return code;
        }
        throw new IllegalArgumentException("Code generation does not support " + type);
    }

    @FunctionalInterface
    private static interface Delegate {
        @Nullable
        public CodeBlock generateCode(Object var1, ResolvableType var2);
    }

    private static class PrimitiveDelegate
    implements Delegate {
        private static final Map<Character, String> CHAR_ESCAPES = Map.of(Character.valueOf('\b'), "\\b", Character.valueOf('\t'), "\\t", Character.valueOf('\n'), "\\n", Character.valueOf('\f'), "\\f", Character.valueOf('\r'), "\\r", Character.valueOf('\"'), "\"", Character.valueOf('\''), "\\'", Character.valueOf('\\'), "\\\\");

        private PrimitiveDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            if (value instanceof Boolean || value instanceof Integer) {
                return CodeBlock.of((String)"$L", (Object[])new Object[]{value});
            }
            if (value instanceof Byte) {
                return CodeBlock.of((String)"(byte) $L", (Object[])new Object[]{value});
            }
            if (value instanceof Short) {
                return CodeBlock.of((String)"(short) $L", (Object[])new Object[]{value});
            }
            if (value instanceof Long) {
                return CodeBlock.of((String)"$LL", (Object[])new Object[]{value});
            }
            if (value instanceof Float) {
                return CodeBlock.of((String)"$LF", (Object[])new Object[]{value});
            }
            if (value instanceof Double) {
                return CodeBlock.of((String)"(double) $L", (Object[])new Object[]{value});
            }
            if (value instanceof Character) {
                Character character = (Character)value;
                return CodeBlock.of((String)"'$L'", (Object[])new Object[]{this.escape(character.charValue())});
            }
            return null;
        }

        private String escape(char ch) {
            String escaped = CHAR_ESCAPES.get(Character.valueOf(ch));
            if (escaped != null) {
                return escaped;
            }
            return !Character.isISOControl(ch) ? Character.toString(ch) : String.format("\\u%04x", ch);
        }
    }

    private static class StringDelegate
    implements Delegate {
        private StringDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            if (value instanceof String) {
                return CodeBlock.of((String)"$S", (Object[])new Object[]{value});
            }
            return null;
        }
    }

    private static class CharsetDelegate
    implements Delegate {
        private CharsetDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            if (value instanceof Charset) {
                Charset charset = (Charset)value;
                return CodeBlock.of((String)"$T.forName($S)", (Object[])new Object[]{Charset.class, charset.name()});
            }
            return null;
        }
    }

    private static class EnumDelegate
    implements Delegate {
        private EnumDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            if (value instanceof Enum) {
                Enum enumValue = (Enum)value;
                return CodeBlock.of((String)"$T.$L", (Object[])new Object[]{enumValue.getDeclaringClass(), enumValue.name()});
            }
            return null;
        }
    }

    private static class ClassDelegate
    implements Delegate {
        private ClassDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            if (value instanceof Class) {
                Class clazz = (Class)value;
                return CodeBlock.of((String)"$T.class", (Object[])new Object[]{ClassUtils.getUserClass((Class)clazz)});
            }
            return null;
        }
    }

    private static class ResolvableTypeDelegate
    implements Delegate {
        private ResolvableTypeDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            if (value instanceof ResolvableType) {
                ResolvableType resolvableType = (ResolvableType)value;
                return ResolvableTypeCodeGenerator.generateCode(resolvableType);
            }
            return null;
        }
    }

    private class ArrayDelegate
    implements Delegate {
        private ArrayDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(@Nullable Object value, ResolvableType type) {
            if (type.isArray()) {
                ResolvableType componentType = type.getComponentType();
                Stream<CodeBlock> elements = Arrays.stream(ObjectUtils.toObjectArray((Object)value)).map(component -> BeanDefinitionPropertyValueCodeGenerator.this.generateCode(component, componentType));
                CodeBlock.Builder code = CodeBlock.builder();
                code.add("new $T {", new Object[]{type.toClass()});
                code.add((CodeBlock)elements.collect(CodeBlock.joining((String)", ")));
                code.add("}", new Object[0]);
                return code.build();
            }
            return null;
        }
    }

    private class ManagedListDelegate
    extends CollectionDelegate<ManagedList<?>> {
        public ManagedListDelegate() {
            super(ManagedList.class, CodeBlock.of((String)"new $T()", (Object[])new Object[]{ManagedList.class}));
        }
    }

    private class ManagedSetDelegate
    extends CollectionDelegate<ManagedSet<?>> {
        public ManagedSetDelegate() {
            super(ManagedSet.class, CodeBlock.of((String)"new $T()", (Object[])new Object[]{ManagedSet.class}));
        }
    }

    private class ManagedMapDelegate
    implements Delegate {
        private static final CodeBlock EMPTY_RESULT = CodeBlock.of((String)"$T.ofEntries()", (Object[])new Object[]{ManagedMap.class});

        private ManagedMapDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            if (value instanceof ManagedMap) {
                ManagedMap managedMap = (ManagedMap)value;
                return this.generateManagedMapCode(type, managedMap);
            }
            return null;
        }

        private <K, V> CodeBlock generateManagedMapCode(ResolvableType type, ManagedMap<K, V> managedMap) {
            if (managedMap.isEmpty()) {
                return EMPTY_RESULT;
            }
            ResolvableType keyType = type.as(Map.class).getGeneric(new int[]{0});
            ResolvableType valueType = type.as(Map.class).getGeneric(new int[]{1});
            CodeBlock.Builder code = CodeBlock.builder();
            code.add("$T.ofEntries(", new Object[]{ManagedMap.class});
            Iterator iterator = managedMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                code.add("$T.entry($L,$L)", new Object[]{Map.class, BeanDefinitionPropertyValueCodeGenerator.this.generateCodeForElement(entry.getKey(), keyType), BeanDefinitionPropertyValueCodeGenerator.this.generateCodeForElement(entry.getValue(), valueType)});
                if (!iterator.hasNext()) continue;
                code.add(", ", new Object[0]);
            }
            code.add(")", new Object[0]);
            return code.build();
        }
    }

    private class ListDelegate
    extends CollectionDelegate<List<?>> {
        ListDelegate() {
            super(List.class, CodeBlock.of((String)"$T.emptyList()", (Object[])new Object[]{Collections.class}));
        }
    }

    private class SetDelegate
    extends CollectionDelegate<Set<?>> {
        SetDelegate() {
            super(Set.class, CodeBlock.of((String)"$T.emptySet()", (Object[])new Object[]{Collections.class}));
        }

        @Override
        protected CodeBlock generateCollectionCode(ResolvableType elementType, Set<?> set) {
            if (set instanceof LinkedHashSet) {
                return CodeBlock.of((String)"new $T($L)", (Object[])new Object[]{LinkedHashSet.class, this.generateCollectionOf(set, List.class, elementType)});
            }
            set = this.orderForCodeConsistency(set);
            return super.generateCollectionCode(elementType, set);
        }

        private Set<?> orderForCodeConsistency(Set<?> set) {
            return new TreeSet(set);
        }
    }

    private class MapDelegate
    implements Delegate {
        private static final CodeBlock EMPTY_RESULT = CodeBlock.of((String)"$T.emptyMap()", (Object[])new Object[]{Collections.class});

        private MapDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            if (value instanceof Map) {
                Map map = (Map)value;
                return this.generateMapCode(type, map);
            }
            return null;
        }

        private <K, V> CodeBlock generateMapCode(ResolvableType type, Map<K, V> map) {
            if (map.isEmpty()) {
                return EMPTY_RESULT;
            }
            ResolvableType keyType = type.as(Map.class).getGeneric(new int[]{0});
            ResolvableType valueType = type.as(Map.class).getGeneric(new int[]{1});
            if (map instanceof LinkedHashMap) {
                return this.generateLinkedHashMapCode(map, keyType, valueType);
            }
            boolean useOfEntries = (map = this.orderForCodeConsistency(map)).size() > 10;
            CodeBlock.Builder code = CodeBlock.builder();
            code.add("$T" + (!useOfEntries ? ".of(" : ".ofEntries("), new Object[]{Map.class});
            Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                CodeBlock keyCode = BeanDefinitionPropertyValueCodeGenerator.this.generateCodeForElement(entry.getKey(), keyType);
                CodeBlock valueCode = BeanDefinitionPropertyValueCodeGenerator.this.generateCodeForElement(entry.getValue(), valueType);
                if (!useOfEntries) {
                    code.add("$L, $L", new Object[]{keyCode, valueCode});
                } else {
                    code.add("$T.entry($L,$L)", new Object[]{Map.class, keyCode, valueCode});
                }
                if (!iterator.hasNext()) continue;
                code.add(", ", new Object[0]);
            }
            code.add(")", new Object[0]);
            return code.build();
        }

        private <K, V> Map<K, V> orderForCodeConsistency(Map<K, V> map) {
            return new TreeMap<K, V>(map);
        }

        private <K, V> CodeBlock generateLinkedHashMapCode(Map<K, V> map, ResolvableType keyType, ResolvableType valueType) {
            GeneratedMethods generatedMethods = BeanDefinitionPropertyValueCodeGenerator.this.generatedMethods;
            GeneratedMethod generatedMethod = generatedMethods.add("getMap", method -> {
                method.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "{\"rawtypes\", \"unchecked\"}", new Object[0]).build());
                method.returns(Map.class);
                method.addStatement("$T map = new $T($L)", new Object[]{Map.class, LinkedHashMap.class, map.size()});
                map.forEach((key, value) -> method.addStatement("map.put($L, $L)", new Object[]{BeanDefinitionPropertyValueCodeGenerator.this.generateCodeForElement(key, keyType), BeanDefinitionPropertyValueCodeGenerator.this.generateCodeForElement(value, valueType)}));
                method.addStatement("return map", new Object[0]);
            });
            return CodeBlock.of((String)"$L()", (Object[])new Object[]{generatedMethod.getName()});
        }
    }

    private static class BeanReferenceDelegate
    implements Delegate {
        private BeanReferenceDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            RuntimeBeanReference runtimeBeanReference;
            if (value instanceof RuntimeBeanReference && (runtimeBeanReference = (RuntimeBeanReference)value).getBeanType() != null) {
                return CodeBlock.of((String)"new $T($T.class)", (Object[])new Object[]{RuntimeBeanReference.class, runtimeBeanReference.getBeanType()});
            }
            if (value instanceof BeanReference) {
                BeanReference beanReference = (BeanReference)value;
                return CodeBlock.of((String)"new $T($S)", (Object[])new Object[]{RuntimeBeanReference.class, beanReference.getBeanName()});
            }
            return null;
        }
    }

    private abstract class CollectionDelegate<T extends Collection<?>>
    implements Delegate {
        private final Class<?> collectionType;
        private final CodeBlock emptyResult;

        public CollectionDelegate(Class<?> collectionType, CodeBlock emptyResult) {
            this.collectionType = collectionType;
            this.emptyResult = emptyResult;
        }

        @Override
        @Nullable
        public CodeBlock generateCode(Object value, ResolvableType type) {
            if (this.collectionType.isInstance(value)) {
                Collection collection = (Collection)value;
                if (collection.isEmpty()) {
                    return this.emptyResult;
                }
                ResolvableType elementType = type.as(this.collectionType).getGeneric(new int[0]);
                return this.generateCollectionCode(elementType, collection);
            }
            return null;
        }

        protected CodeBlock generateCollectionCode(ResolvableType elementType, T collection) {
            return this.generateCollectionOf((Collection<?>)collection, this.collectionType, elementType);
        }

        protected final CodeBlock generateCollectionOf(Collection<?> collection, Class<?> collectionType, ResolvableType elementType) {
            CodeBlock.Builder code = CodeBlock.builder();
            code.add("$T.of(", new Object[]{collectionType});
            Iterator<?> iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                code.add("$L", new Object[]{BeanDefinitionPropertyValueCodeGenerator.this.generateCodeForElement(element, elementType)});
                if (!iterator.hasNext()) continue;
                code.add(", ", new Object[0]);
            }
            code.add(")", new Object[0]);
            return code.build();
        }
    }
}

