/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.jcache.interceptor;

import java.util.Collection;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.CacheOperationInvocationContext;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.cache.interceptor.SimpleCacheResolver;
import org.springframework.cache.interceptor.SimpleKeyGenerator;
import org.springframework.cache.jcache.interceptor.AnnotationJCacheOperationSource;
import org.springframework.cache.jcache.interceptor.JCacheOperationSource;
import org.springframework.cache.jcache.interceptor.KeyGeneratorAdapter;
import org.springframework.cache.jcache.interceptor.SimpleExceptionCacheResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DefaultJCacheOperationSource
extends AnnotationJCacheOperationSource
implements BeanFactoryAware,
InitializingBean,
SmartInitializingSingleton {
    @Nullable
    private CacheManager cacheManager;
    @Nullable
    private CacheResolver cacheResolver;
    @Nullable
    private CacheResolver exceptionCacheResolver;
    private KeyGenerator keyGenerator = new SimpleKeyGenerator();
    @Nullable
    private KeyGenerator adaptedKeyGenerator;
    @Nullable
    private BeanFactory beanFactory;

    public void setCacheManager(@Nullable CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Nullable
    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheResolver(@Nullable CacheResolver cacheResolver) {
        this.cacheResolver = cacheResolver;
    }

    @Nullable
    public CacheResolver getCacheResolver() {
        return this.cacheResolver;
    }

    public void setExceptionCacheResolver(@Nullable CacheResolver exceptionCacheResolver) {
        this.exceptionCacheResolver = exceptionCacheResolver;
    }

    @Nullable
    public CacheResolver getExceptionCacheResolver() {
        return this.exceptionCacheResolver;
    }

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public KeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() {
        this.adaptedKeyGenerator = new KeyGeneratorAdapter((JCacheOperationSource)this, this.keyGenerator);
    }

    public void afterSingletonsInstantiated() {
        Assert.notNull((Object)this.getDefaultCacheResolver(), (String)"Cache resolver should have been initialized");
    }

    @Override
    protected <T> T getBean(Class<T> type) {
        Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)("BeanFactory required for resolution of [" + type + "]"));
        try {
            return (T)this.beanFactory.getBean(type);
        }
        catch (NoUniqueBeanDefinitionException ex) {
            throw new IllegalStateException("No unique [" + type.getName() + "] bean found in application context - mark one as primary, or declare a more specific implementation type for your cache", ex);
        }
        catch (NoSuchBeanDefinitionException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No bean of type [" + type.getName() + "] found in application context"), (Throwable)ex);
            }
            return (T)BeanUtils.instantiateClass(type);
        }
    }

    protected CacheManager getDefaultCacheManager() {
        if (this.cacheManager == null) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory required for default CacheManager resolution");
            try {
                this.cacheManager = (CacheManager)this.beanFactory.getBean(CacheManager.class);
            }
            catch (NoUniqueBeanDefinitionException ex) {
                throw new IllegalStateException("No unique bean of type CacheManager found. Mark one as primary or declare a specific CacheManager to use.");
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new IllegalStateException("No bean of type CacheManager found. Register a CacheManager bean or remove the @EnableCaching annotation from your configuration.");
            }
        }
        return this.cacheManager;
    }

    @Override
    protected CacheResolver getDefaultCacheResolver() {
        if (this.cacheResolver == null) {
            this.cacheResolver = new SimpleCacheResolver(this.getDefaultCacheManager());
        }
        return this.cacheResolver;
    }

    @Override
    protected CacheResolver getDefaultExceptionCacheResolver() {
        if (this.exceptionCacheResolver == null) {
            this.exceptionCacheResolver = new LazyCacheResolver();
        }
        return this.exceptionCacheResolver;
    }

    @Override
    protected KeyGenerator getDefaultKeyGenerator() {
        Assert.state((this.adaptedKeyGenerator != null ? 1 : 0) != 0, (String)"KeyGenerator not initialized");
        return this.adaptedKeyGenerator;
    }

    class LazyCacheResolver
    implements CacheResolver {
        @Nullable
        private CacheResolver cacheResolver;

        LazyCacheResolver() {
        }

        public Collection<? extends Cache> resolveCaches(CacheOperationInvocationContext<?> context) {
            if (this.cacheResolver == null) {
                this.cacheResolver = new SimpleExceptionCacheResolver(DefaultJCacheOperationSource.this.getDefaultCacheManager());
            }
            return this.cacheResolver.resolveCaches(context);
        }
    }
}

