/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelNode;
import org.springframework.expression.spel.ast.Literal;
import org.springframework.expression.spel.ast.SpelNodeImpl;

public class InlineList
extends SpelNodeImpl {
    TypedValue constant = null;

    public InlineList(int pos, SpelNodeImpl ... args) {
        super(pos, args);
        this.checkIfConstant();
    }

    private void checkIfConstant() {
        boolean isConstant = true;
        int max = this.getChildCount();
        for (int c = 0; c < max; ++c) {
            SpelNode child = this.getChild(c);
            if (child instanceof Literal) continue;
            if (child instanceof InlineList) {
                InlineList inlineList = (InlineList)child;
                if (inlineList.isConstant()) continue;
                isConstant = false;
                continue;
            }
            isConstant = false;
        }
        if (isConstant) {
            ArrayList<Object> constantList = new ArrayList<Object>();
            int childcount = this.getChildCount();
            for (int c = 0; c < childcount; ++c) {
                SpelNode child = this.getChild(c);
                if (child instanceof Literal) {
                    constantList.add(((Literal)child).getLiteralValue().getValue());
                    continue;
                }
                if (!(child instanceof InlineList)) continue;
                constantList.add(((InlineList)child).getConstantValue());
            }
            this.constant = new TypedValue(Collections.unmodifiableList(constantList));
        }
    }

    @Override
    public TypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        if (this.constant != null) {
            return this.constant;
        }
        ArrayList<Object> returnValue = new ArrayList<Object>();
        int childcount = this.getChildCount();
        for (int c = 0; c < childcount; ++c) {
            returnValue.add(this.getChild(c).getValue(expressionState));
        }
        return new TypedValue(returnValue);
    }

    @Override
    public String toStringAST() {
        StringBuilder s = new StringBuilder();
        s.append('{');
        int count = this.getChildCount();
        for (int c = 0; c < count; ++c) {
            if (c > 0) {
                s.append(',');
            }
            s.append(this.getChild(c).toStringAST());
        }
        s.append('}');
        return s.toString();
    }

    public boolean isConstant() {
        return this.constant != null;
    }

    public List<Object> getConstantValue() {
        return (List)this.constant.getValue();
    }
}

