/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.tcp.reactor;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.ListenableFutureCallbackRegistry;
import org.springframework.util.concurrent.SuccessCallback;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

abstract class AbstractMonoToListenableFutureAdapter<S, T>
implements ListenableFuture<T> {
    private final MonoProcessor<S> monoProcessor;
    private final ListenableFutureCallbackRegistry<T> registry = new ListenableFutureCallbackRegistry();

    protected AbstractMonoToListenableFutureAdapter(Mono<S> mono) {
        Assert.notNull(mono, (String)"Mono must not be null");
        this.monoProcessor = mono.doOnSuccess(result -> {
            T adapted;
            try {
                adapted = this.adapt(result);
            }
            catch (Throwable ex) {
                this.registry.failure(ex);
                return;
            }
            this.registry.success(adapted);
        }).doOnError(arg_0 -> this.registry.failure(arg_0)).toProcessor();
    }

    @Nullable
    public T get() throws InterruptedException {
        Object result = this.monoProcessor.block();
        return this.adapt(result);
    }

    @Nullable
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Assert.notNull((Object)((Object)unit), (String)"TimeUnit must not be null");
        Duration duration = Duration.ofMillis(TimeUnit.MILLISECONDS.convert(timeout, unit));
        Object result = this.monoProcessor.block(duration);
        return this.adapt(result);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isCancelled()) {
            return false;
        }
        this.monoProcessor.cancel();
        return true;
    }

    public boolean isCancelled() {
        return this.monoProcessor.isCancelled();
    }

    public boolean isDone() {
        return this.monoProcessor.isTerminated();
    }

    public void addCallback(ListenableFutureCallback<? super T> callback) {
        this.registry.addCallback(callback);
    }

    public void addCallback(SuccessCallback<? super T> successCallback, FailureCallback failureCallback) {
        this.registry.addSuccessCallback(successCallback);
        this.registry.addFailureCallback(failureCallback);
    }

    @Nullable
    protected abstract T adapt(@Nullable S var1);
}

